% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_local_gateway_route}
\alias{ec2_modify_local_gateway_route}
\title{Modifies the specified local gateway route}
\usage{
ec2_modify_local_gateway_route(
  DestinationCidrBlock = NULL,
  LocalGatewayRouteTableId,
  LocalGatewayVirtualInterfaceGroupId = NULL,
  NetworkInterfaceId = NULL,
  DryRun = NULL,
  DestinationPrefixListId = NULL
)
}
\arguments{
\item{DestinationCidrBlock}{The CIDR block used for destination matches. The value that you provide
must match the CIDR of an existing route in the table.}

\item{LocalGatewayRouteTableId}{[required] The ID of the local gateway route table.}

\item{LocalGatewayVirtualInterfaceGroupId}{The ID of the virtual interface group.}

\item{NetworkInterfaceId}{The ID of the network interface.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{DestinationPrefixListId}{The ID of the prefix list. Use a prefix list in place of
\code{DestinationCidrBlock}. You cannot use \code{DestinationPrefixListId} and
\code{DestinationCidrBlock} in the same request.}
}
\description{
Modifies the specified local gateway route.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_local_gateway_route/} for full documentation.
}
\keyword{internal}
