% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagebuilder_operations.R
\name{imagebuilder_list_components}
\alias{imagebuilder_list_components}
\title{Returns the list of components that can be filtered by name, or by using
the listed filters to streamline results}
\usage{
imagebuilder_list_components(
  owner = NULL,
  filters = NULL,
  byName = NULL,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{owner}{Filters results based on the type of owner for the component. By
default, this request returns a list of components that your account
owns. To see results for other types of owners, you can specify
components that Amazon manages, third party components, or components
that other accounts have shared with you.}

\item{filters}{Use the following filters to streamline results:
\itemize{
\item \code{description}
\item \code{name}
\item \code{platform}
\item \code{supportedOsVersion}
\item \code{type}
\item \code{version}
}}

\item{byName}{Returns the list of components for the specified name.}

\item{maxResults}{The maximum items to return in a request.}

\item{nextToken}{A token to specify where to start paginating. This is the NextToken from
a previously truncated response.}
}
\description{
Returns the list of components that can be filtered by name, or by using the listed \code{filters} to streamline results. Newly created components can take up to two minutes to appear in the ListComponents API Results.

See \url{https://www.paws-r-sdk.com/docs/imagebuilder_list_components/} for full documentation.
}
\keyword{internal}
