% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_capacity_block_offerings}
\alias{ec2_describe_capacity_block_offerings}
\title{Describes Capacity Block offerings available for purchase}
\usage{
ec2_describe_capacity_block_offerings(
  DryRun = NULL,
  InstanceType,
  InstanceCount,
  StartDateRange = NULL,
  EndDateRange = NULL,
  CapacityDurationHours,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceType}{[required] The type of instance for which the Capacity Block offering reserves
capacity.}

\item{InstanceCount}{[required] The number of instances for which to reserve capacity.}

\item{StartDateRange}{The earliest start date for the Capacity Block offering.}

\item{EndDateRange}{The latest end date for the Capacity Block offering.}

\item{CapacityDurationHours}{[required] The number of hours for which to reserve Capacity Block.}

\item{NextToken}{The token to use to retrieve the next page of results.}

\item{MaxResults}{The maximum number of results to return for the request in a single
page. The remaining results can be seen by sending another request with
the returned \code{nextToken} value. This value can be between 5 and 500. If
\code{maxResults} is given a larger value than 500, you receive an error.}
}
\description{
Describes Capacity Block offerings available for purchase. With Capacity Blocks, you purchase a specific instance type for a period of time.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_capacity_block_offerings/} for full documentation.
}
\keyword{internal}
