% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_ipam_scope}
\alias{ec2_create_ipam_scope}
\title{Create an IPAM scope}
\usage{
ec2_create_ipam_scope(
  DryRun = NULL,
  IpamId,
  Description = NULL,
  TagSpecifications = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamId}{[required] The ID of the IPAM for which you're creating this scope.}

\item{Description}{A description for the scope you're creating.}

\item{TagSpecifications}{The key/value combination of a tag assigned to the resource. Use the tag
key in the filter name and the tag value as the filter value. For
example, to find all resources that have a tag with the key \code{Owner} and
the value \code{TeamA}, specify \code{tag:Owner} for the filter name and \code{TeamA}
for the filter value.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring Idempotency}.}
}
\description{
Create an IPAM scope. In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP addresses across multiple unconnected networks without causing IP address overlap or conflict.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_ipam_scope/} for full documentation.
}
\keyword{internal}
