# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Cost and Usage Report Service
#'
#' @description
#' The AWS Cost and Usage Report API enables you to programmatically
#' create, query, and delete AWS Cost and Usage report definitions.
#' 
#' AWS Cost and Usage reports track the monthly AWS costs and usage
#' associated with your AWS account. The report contains line items for
#' each unique combination of AWS product, usage type, and operation that
#' your AWS account uses. You can configure the AWS Cost and Usage report
#' to show only the data that you want, using the AWS Cost and Usage API.
#' 
#' Service Endpoint
#' 
#' The AWS Cost and Usage Report API provides the following endpoint:
#' 
#' -   cur.us-east-1.amazonaws.com
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- costandusagereportservice(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example deletes the AWS Cost and Usage report named
#' # ExampleReport.
#' \donttest{svc <- costandusagereportservice()
#' svc$delete_report_definition(
#'   ReportName = "ExampleReport"
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=costandusagereportservice_delete_report_definition]{delete_report_definition} \tab Deletes the specified report \cr
#'  \link[=costandusagereportservice_describe_report_definitions]{describe_report_definitions} \tab Lists the AWS Cost and Usage reports available to this account\cr
#'  \link[=costandusagereportservice_modify_report_definition]{modify_report_definition} \tab Allows you to programatically update your report preferences \cr
#'  \link[=costandusagereportservice_put_report_definition]{put_report_definition} \tab Creates a new report using the description that you provide 
#' }
#'
#' @rdname costandusagereportservice
#' @export
costandusagereportservice <- function(config = list()) {
  svc <- .costandusagereportservice$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.costandusagereportservice <- list()

.costandusagereportservice$operations <- list()

.costandusagereportservice$metadata <- list(
  service_name = "cur",
  endpoints = list("*" = list(endpoint = "cur.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "cur.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "Cost and Usage Report Service",
  api_version = "2017-01-06",
  signing_name = "cur",
  json_version = "1.1",
  target_prefix = "AWSOrigamiServiceGatewayService"
)

.costandusagereportservice$handlers <- new_handlers("jsonrpc", "v4")

.costandusagereportservice$service <- function(config = list()) {
  new_service(.costandusagereportservice$metadata, .costandusagereportservice$handlers, config)
}
