% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paymentcryptographycontrolplane_operations.R
\name{paymentcryptographycontrolplane_create_alias}
\alias{paymentcryptographycontrolplane_create_alias}
\title{Creates an alias, or a friendly name, for an Amazon Web Services Payment
Cryptography key}
\usage{
paymentcryptographycontrolplane_create_alias(AliasName, KeyArn = NULL)
}
\arguments{
\item{AliasName}{[required] A friendly name that you can use to refer to a key. An alias must begin
with \verb{alias/} followed by a name, for example \code{alias/ExampleAlias}. It
can contain only alphanumeric characters, forward slashes (/),
underscores (_), and dashes (-).

Don't include personal, confidential or sensitive information in this
field. This field may be displayed in plaintext in CloudTrail logs and
other output.}

\item{KeyArn}{The \code{KeyARN} of the key to associate with the alias.}
}
\description{
Creates an \emph{alias}, or a friendly name, for an Amazon Web Services Payment Cryptography key. You can use an alias to identify a key in the console and when you call cryptographic operations such as \href{https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_EncryptData.html}{EncryptData} or \href{https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_DecryptData.html}{DecryptData}.

See \url{https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_create_alias/} for full documentation.
}
\keyword{internal}
