% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointemail_operations.R
\name{pinpointemail_create_email_identity}
\alias{pinpointemail_create_email_identity}
\title{Verifies an email identity for use with Amazon Pinpoint}
\usage{
pinpointemail_create_email_identity(EmailIdentity, Tags)
}
\arguments{
\item{EmailIdentity}{[required] The email address or domain that you want to verify.}

\item{Tags}{An array of objects that define the tags (keys and values) that you want
to associate with the email identity.}
}
\description{
Verifies an email identity for use with Amazon Pinpoint. In Amazon
Pinpoint, an identity is an email address or domain that you use when
you send email. Before you can use an identity to send email with Amazon
Pinpoint, you first have to verify it. By verifying an address, you
demonstrate that you're the owner of the address, and that you've
given Amazon Pinpoint permission to send email from the address.
}
\details{
When you verify an email address, Amazon Pinpoint sends an email to the
address. Your email address is verified as soon as you follow the link
in the verification email.

When you verify a domain, this operation provides a set of DKIM tokens,
which you can convert into CNAME tokens. You add these CNAME tokens to
the DNS configuration for your domain. Your domain is verified when
Amazon Pinpoint detects these records in the DNS configuration for your
domain. It usually takes around 72 hours to complete the domain
verification process.
}
\section{Request syntax}{
\preformatted{svc$create_email_identity(
  EmailIdentity = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
