% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_copy_option_group}
\alias{rds_copy_option_group}
\title{Copies the specified option group}
\usage{
rds_copy_option_group(SourceOptionGroupIdentifier,
  TargetOptionGroupIdentifier, TargetOptionGroupDescription, Tags)
}
\arguments{
\item{SourceOptionGroupIdentifier}{[required] The identifier for the source option group.

Constraints:
\itemize{
\item Must specify a valid option group.
}}

\item{TargetOptionGroupIdentifier}{[required] The identifier for the copied option group.

Constraints:
\itemize{
\item Can't be null, empty, or blank
\item Must contain from 1 to 255 letters, numbers, or hyphens
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}

Example: \code{my-option-group}}

\item{TargetOptionGroupDescription}{[required] The description for the copied option group.}

\item{Tags}{}
}
\description{
Copies the specified option group.
}
\section{Request syntax}{
\preformatted{svc$copy_option_group(
  SourceOptionGroupIdentifier = "string",
  TargetOptionGroupIdentifier = "string",
  TargetOptionGroupDescription = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
