% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_delete_db_cluster_snapshot}
\alias{rds_delete_db_cluster_snapshot}
\title{Deletes a DB cluster snapshot}
\usage{
rds_delete_db_cluster_snapshot(DBClusterSnapshotIdentifier)
}
\arguments{
\item{DBClusterSnapshotIdentifier}{[required] The identifier of the DB cluster snapshot to delete.

Constraints: Must be the name of an existing DB cluster snapshot in the
\code{available} state.}
}
\description{
Deletes a DB cluster snapshot. If the snapshot is being copied, the copy
operation is terminated.

The DB cluster snapshot must be in the \code{available} state to be deleted.

For more information on Amazon Aurora, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html}{What Is Amazon Aurora?}
in the \emph{Amazon Aurora User Guide.}

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$delete_db_cluster_snapshot(
  DBClusterSnapshotIdentifier = "string"
)
}
}

\keyword{internal}
