% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_describe_table_replica_auto_scaling}
\alias{dynamodb_describe_table_replica_auto_scaling}
\title{Describes auto scaling settings across replicas of the global table at
once}
\usage{
dynamodb_describe_table_replica_auto_scaling(TableName)
}
\arguments{
\item{TableName}{[required] The name of the table.}
}
\value{
A list with the following syntax:\preformatted{list(
  TableAutoScalingDescription = list(
    TableName = "string",
    TableStatus = "CREATING"|"UPDATING"|"DELETING"|"ACTIVE"|"INACCESSIBLE_ENCRYPTION_CREDENTIALS"|"ARCHIVING"|"ARCHIVED",
    Replicas = list(
      list(
        RegionName = "string",
        GlobalSecondaryIndexes = list(
          list(
            IndexName = "string",
            IndexStatus = "CREATING"|"UPDATING"|"DELETING"|"ACTIVE",
            ProvisionedReadCapacityAutoScalingSettings = list(
              MinimumUnits = 123,
              MaximumUnits = 123,
              AutoScalingDisabled = TRUE|FALSE,
              AutoScalingRoleArn = "string",
              ScalingPolicies = list(
                list(
                  PolicyName = "string",
                  TargetTrackingScalingPolicyConfiguration = list(
                    DisableScaleIn = TRUE|FALSE,
                    ScaleInCooldown = 123,
                    ScaleOutCooldown = 123,
                    TargetValue = 123.0
                  )
                )
              )
            ),
            ProvisionedWriteCapacityAutoScalingSettings = list(
              MinimumUnits = 123,
              MaximumUnits = 123,
              AutoScalingDisabled = TRUE|FALSE,
              AutoScalingRoleArn = "string",
              ScalingPolicies = list(
                list(
                  PolicyName = "string",
                  TargetTrackingScalingPolicyConfiguration = list(
                    DisableScaleIn = TRUE|FALSE,
                    ScaleInCooldown = 123,
                    ScaleOutCooldown = 123,
                    TargetValue = 123.0
                  )
                )
              )
            )
          )
        ),
        ReplicaProvisionedReadCapacityAutoScalingSettings = list(
          MinimumUnits = 123,
          MaximumUnits = 123,
          AutoScalingDisabled = TRUE|FALSE,
          AutoScalingRoleArn = "string",
          ScalingPolicies = list(
            list(
              PolicyName = "string",
              TargetTrackingScalingPolicyConfiguration = list(
                DisableScaleIn = TRUE|FALSE,
                ScaleInCooldown = 123,
                ScaleOutCooldown = 123,
                TargetValue = 123.0
              )
            )
          )
        ),
        ReplicaProvisionedWriteCapacityAutoScalingSettings = list(
          MinimumUnits = 123,
          MaximumUnits = 123,
          AutoScalingDisabled = TRUE|FALSE,
          AutoScalingRoleArn = "string",
          ScalingPolicies = list(
            list(
              PolicyName = "string",
              TargetTrackingScalingPolicyConfiguration = list(
                DisableScaleIn = TRUE|FALSE,
                ScaleInCooldown = 123,
                ScaleOutCooldown = 123,
                TargetValue = 123.0
              )
            )
          )
        ),
        ReplicaStatus = "CREATING"|"CREATION_FAILED"|"UPDATING"|"DELETING"|"ACTIVE"|"REGION_DISABLED"|"INACCESSIBLE_ENCRYPTION_CREDENTIALS"
      )
    )
  )
)
}
}
\description{
Describes auto scaling settings across replicas of the global table at
once.

This operation only applies to \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html}{Version 2019.11.21}
of global tables.
}
\section{Request syntax}{
\preformatted{svc$describe_table_replica_auto_scaling(
  TableName = "string"
)
}
}

\keyword{internal}
