% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_apply_pending_maintenance_action}
\alias{neptune_apply_pending_maintenance_action}
\title{Applies a pending maintenance action to a resource (for example, to a DB
instance)}
\usage{
neptune_apply_pending_maintenance_action(ResourceIdentifier,
  ApplyAction, OptInType)
}
\arguments{
\item{ResourceIdentifier}{[required] The Amazon Resource Name (ARN) of the resource that the pending
maintenance action applies to. For information about creating an ARN,
see \href{https://docs.aws.amazon.com/neptune/latest/userguide/#tagging.ARN.Constructing}{Constructing an Amazon Resource Name (ARN)}.}

\item{ApplyAction}{[required] The pending maintenance action to apply to this resource.

Valid values: \code{system-update}, \code{db-upgrade}}

\item{OptInType}{[required] A value that specifies the type of opt-in request, or undoes an opt-in
request. An opt-in request of type \code{immediate} can't be undone.

Valid values:
\itemize{
\item \code{immediate} - Apply the maintenance action immediately.
\item \code{next-maintenance} - Apply the maintenance action during the next
maintenance window for the resource.
\item \verb{undo-opt-in} - Cancel any existing \code{next-maintenance} opt-in
requests.
}}
}
\value{
A list with the following syntax:\preformatted{list(
  ResourcePendingMaintenanceActions = list(
    ResourceIdentifier = "string",
    PendingMaintenanceActionDetails = list(
      list(
        Action = "string",
        AutoAppliedAfterDate = as.POSIXct(
          "2015-01-01"
        ),
        ForcedApplyDate = as.POSIXct(
          "2015-01-01"
        ),
        OptInStatus = "string",
        CurrentApplyDate = as.POSIXct(
          "2015-01-01"
        ),
        Description = "string"
      )
    )
  )
)
}
}
\description{
Applies a pending maintenance action to a resource (for example, to a DB
instance).
}
\section{Request syntax}{
\preformatted{svc$apply_pending_maintenance_action(
  ResourceIdentifier = "string",
  ApplyAction = "string",
  OptInType = "string"
)
}
}

\keyword{internal}
