% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_cluster_parameter_groups}
\alias{rds_describe_db_cluster_parameter_groups}
\title{Returns a list of DBClusterParameterGroup descriptions}
\usage{
rds_describe_db_cluster_parameter_groups(DBClusterParameterGroupName,
  Filters, MaxRecords, Marker)
}
\arguments{
\item{DBClusterParameterGroupName}{The name of a specific DB cluster parameter group to return details for.

Constraints:
\itemize{
\item If supplied, must match the name of an existing
DBClusterParameterGroup.
}}

\item{Filters}{This parameter isn't currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=rds_describe_db_cluster_parameter_groups]{describe_db_cluster_parameter_groups}}
request. If this parameter is specified, the response includes only
records beyond the marker, up to the value specified by \code{MaxRecords}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Marker = "string",
  DBClusterParameterGroups = list(
    list(
      DBClusterParameterGroupName = "string",
      DBParameterGroupFamily = "string",
      Description = "string",
      DBClusterParameterGroupArn = "string"
    )
  )
)
}
}
\description{
Returns a list of \code{DBClusterParameterGroup} descriptions. If a
\code{DBClusterParameterGroupName} parameter is specified, the list will
contain only the description of the specified DB cluster parameter
group.

For more information on Amazon Aurora, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html}{What Is Amazon Aurora?}
in the \emph{Amazon Aurora User Guide.}

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$describe_db_cluster_parameter_groups(
  DBClusterParameterGroupName = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
