% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_revoke_cluster_security_group_ingress}
\alias{redshift_revoke_cluster_security_group_ingress}
\title{Revokes an ingress rule in an Amazon Redshift security group for a
previously authorized IP range or Amazon EC2 security group}
\usage{
redshift_revoke_cluster_security_group_ingress(ClusterSecurityGroupName,
  CIDRIP, EC2SecurityGroupName, EC2SecurityGroupOwnerId)
}
\arguments{
\item{ClusterSecurityGroupName}{[required] The name of the security Group from which to revoke the ingress rule.}

\item{CIDRIP}{The IP range for which to revoke access. This range must be a valid
Classless Inter-Domain Routing (CIDR) block of IP addresses. If \code{CIDRIP}
is specified, \code{EC2SecurityGroupName} and \code{EC2SecurityGroupOwnerId}
cannot be provided.}

\item{EC2SecurityGroupName}{The name of the EC2 Security Group whose access is to be revoked. If
\code{EC2SecurityGroupName} is specified, \code{EC2SecurityGroupOwnerId} must also
be provided and \code{CIDRIP} cannot be provided.}

\item{EC2SecurityGroupOwnerId}{The AWS account number of the owner of the security group specified in
the \code{EC2SecurityGroupName} parameter. The AWS access key ID is not an
acceptable value. If \code{EC2SecurityGroupOwnerId} is specified,
\code{EC2SecurityGroupName} must also be provided. and \code{CIDRIP} cannot be
provided.

Example: \code{111122223333}}
}
\value{
A list with the following syntax:\preformatted{list(
  ClusterSecurityGroup = list(
    ClusterSecurityGroupName = "string",
    Description = "string",
    EC2SecurityGroups = list(
      list(
        Status = "string",
        EC2SecurityGroupName = "string",
        EC2SecurityGroupOwnerId = "string",
        Tags = list(
          list(
            Key = "string",
            Value = "string"
          )
        )
      )
    ),
    IPRanges = list(
      list(
        Status = "string",
        CIDRIP = "string",
        Tags = list(
          list(
            Key = "string",
            Value = "string"
          )
        )
      )
    ),
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  )
)
}
}
\description{
Revokes an ingress rule in an Amazon Redshift security group for a
previously authorized IP range or Amazon EC2 security group. To add an
ingress rule, see
\code{\link[=redshift_authorize_cluster_security_group_ingress]{authorize_cluster_security_group_ingress}}.
For information about managing security groups, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html}{Amazon Redshift Cluster Security Groups}
in the \emph{Amazon Redshift Cluster Management Guide}.
}
\section{Request syntax}{
\preformatted{svc$revoke_cluster_security_group_ingress(
  ClusterSecurityGroupName = "string",
  CIDRIP = "string",
  EC2SecurityGroupName = "string",
  EC2SecurityGroupOwnerId = "string"
)
}
}

\keyword{internal}
