% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_describe_db_instances}
\alias{docdb_describe_db_instances}
\title{Returns information about provisioned Amazon DocumentDB instances}
\usage{
docdb_describe_db_instances(DBInstanceIdentifier, Filters, MaxRecords,
  Marker)
}
\arguments{
\item{DBInstanceIdentifier}{The user-provided instance identifier. If this parameter is specified,
information from only the specific DB instance is returned. This
parameter isn't case sensitive.

Constraints:
\itemize{
\item If provided, must match the identifier of an existing \code{DBInstance}.
}}

\item{Filters}{A filter that specifies one or more DB instances to describe.

Supported filters:
\itemize{
\item \code{db-cluster-id} - Accepts DB cluster identifiers and DB cluster
Amazon Resource Names (ARNs). The results list includes only the
information about the DB instances that are associated with the DB
clusters that are identified by these ARNs.
\item \code{db-instance-id} - Accepts DB instance identifiers and DB instance
ARNs. The results list includes only the information about the DB
instances that are identified by these ARNs.
}}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
(marker) is included in the response so that the remaining results can
be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous request. If this
parameter is specified, the response includes only records beyond the
marker, up to the value specified by \code{MaxRecords}.}
}
\description{
Returns information about provisioned Amazon DocumentDB instances. This
API supports pagination.
}
\section{Request syntax}{
\preformatted{svc$describe_db_instances(
  DBInstanceIdentifier = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
