% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_events}
\alias{redshift_describe_events}
\title{Returns events related to clusters, security groups, snapshots, and
parameter groups for the past 14 days}
\usage{
redshift_describe_events(SourceIdentifier, SourceType, StartTime,
  EndTime, Duration, MaxRecords, Marker)
}
\arguments{
\item{SourceIdentifier}{The identifier of the event source for which events will be returned. If
this parameter is not specified, then all sources are included in the
response.

Constraints:

If \emph{SourceIdentifier} is supplied, \emph{SourceType} must also be provided.
\itemize{
\item Specify a cluster identifier when \emph{SourceType} is \code{cluster}.
\item Specify a cluster security group name when \emph{SourceType} is
\code{cluster-security-group}.
\item Specify a cluster parameter group name when \emph{SourceType} is
\code{cluster-parameter-group}.
\item Specify a cluster snapshot identifier when \emph{SourceType} is
\code{cluster-snapshot}.
}}

\item{SourceType}{The event source to retrieve events for. If no value is specified, all
events are returned.

Constraints:

If \emph{SourceType} is supplied, \emph{SourceIdentifier} must also be provided.
\itemize{
\item Specify \code{cluster} when \emph{SourceIdentifier} is a cluster identifier.
\item Specify \code{cluster-security-group} when \emph{SourceIdentifier} is a
cluster security group name.
\item Specify \code{cluster-parameter-group} when \emph{SourceIdentifier} is a
cluster parameter group name.
\item Specify \code{cluster-snapshot} when \emph{SourceIdentifier} is a cluster
snapshot identifier.
}}

\item{StartTime}{The beginning of the time interval to retrieve events for, specified in
ISO 8601 format. For more information about ISO 8601, go to the \href{http://en.wikipedia.org/wiki/ISO_8601}{ISO8601 Wikipedia page.}

Example: \verb{2009-07-08T18:00Z}}

\item{EndTime}{The end of the time interval for which to retrieve events, specified in
ISO 8601 format. For more information about ISO 8601, go to the \href{http://en.wikipedia.org/wiki/ISO_8601}{ISO8601 Wikipedia page.}

Example: \verb{2009-07-08T18:00Z}}

\item{Duration}{The number of minutes prior to the time of the request for which to
retrieve events. For example, if the request is sent at 18:00 and you
specify a duration of 60, then only events which have occurred after
17:00 will be returned.

Default: \code{60}}

\item{MaxRecords}{The maximum number of response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned marker value.

Default: \code{100}

Constraints: minimum 20, maximum 100.}

\item{Marker}{An optional parameter that specifies the starting point to return a set
of response records. When the results of a DescribeEvents request exceed
the value specified in \code{MaxRecords}, AWS returns a value in the \code{Marker}
field of the response. You can retrieve the next set of response records
by providing the returned marker value in the \code{Marker} parameter and
retrying the request.}
}
\description{
Returns events related to clusters, security groups, snapshots, and
parameter groups for the past 14 days. Events specific to a particular
cluster, security group, snapshot or parameter group can be obtained by
providing the name as a parameter. By default, the past hour of events
are returned.
}
\section{Request syntax}{
\preformatted{svc$describe_events(
  SourceIdentifier = "string",
  SourceType = "cluster"|"cluster-parameter-group"|"cluster-security-group"|"cluster-snapshot"|"scheduled-action",
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  Duration = 123,
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
