% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_list_global_tables}
\alias{dynamodb_list_global_tables}
\title{Lists all global tables that have a replica in the specified Region}
\usage{
dynamodb_list_global_tables(ExclusiveStartGlobalTableName, Limit,
  RegionName)
}
\arguments{
\item{ExclusiveStartGlobalTableName}{The first global table name that this operation will evaluate.}

\item{Limit}{The maximum number of table names to return.}

\item{RegionName}{Lists the global tables in a specific Region.}
}
\description{
Lists all global tables that have a replica in the specified Region.
}
\details{
This method only applies to \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html}{Version 2017.11.29}
of global tables.
}
\section{Request syntax}{
\preformatted{svc$list_global_tables(
  ExclusiveStartGlobalTableName = "string",
  Limit = 123,
  RegionName = "string"
)
}
}

\keyword{internal}
