% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_db_instance_read_replica}
\alias{rds_create_db_instance_read_replica}
\title{Creates a new DB instance that acts as a Read Replica for an existing
source DB instance}
\usage{
rds_create_db_instance_read_replica(DBInstanceIdentifier,
  SourceDBInstanceIdentifier, DBInstanceClass, AvailabilityZone, Port,
  MultiAZ, AutoMinorVersionUpgrade, Iops, OptionGroupName,
  DBParameterGroupName, PubliclyAccessible, Tags, DBSubnetGroupName,
  VpcSecurityGroupIds, StorageType, CopyTagsToSnapshot,
  MonitoringInterval, MonitoringRoleArn, KmsKeyId, PreSignedUrl,
  EnableIAMDatabaseAuthentication, EnablePerformanceInsights,
  PerformanceInsightsKMSKeyId, PerformanceInsightsRetentionPeriod,
  EnableCloudwatchLogsExports, ProcessorFeatures,
  UseDefaultProcessorFeatures, DeletionProtection, Domain,
  DomainIAMRoleName, SourceRegion)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The DB instance identifier of the Read Replica. This identifier is the
unique key that identifies a DB instance. This parameter is stored as a
lowercase string.}

\item{SourceDBInstanceIdentifier}{[required] The identifier of the DB instance that will act as the source for the
Read Replica. Each DB instance can have up to five Read Replicas.

Constraints:
\itemize{
\item Must be the identifier of an existing MySQL, MariaDB, Oracle, or
PostgreSQL DB instance.
\item Can specify a DB instance that is a MySQL Read Replica only if the
source is running MySQL 5.6 or later.
\item For the limitations of Oracle Read Replicas, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html}{Read Replica Limitations with Oracle}
in the \emph{Amazon RDS User Guide}.
\item Can specify a DB instance that is a PostgreSQL DB instance only if
the source is running PostgreSQL 9.3.5 or later (9.4.7 and higher
for cross-region replication).
\item The specified DB instance must have automatic backups enabled, its
backup retention period must be greater than 0.
\item If the source DB instance is in the same AWS Region as the Read
Replica, specify a valid DB instance identifier.
\item If the source DB instance is in a different AWS Region than the Read
Replica, specify a valid DB instance ARN. For more information, go
to \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing}{Constructing an ARN for Amazon RDS}
in the \emph{Amazon RDS User Guide}.
}}

\item{DBInstanceClass}{The compute and memory capacity of the Read Replica, for example,
\code{db.m4.large}. Not all DB instance classes are available in all AWS
Regions, or for all database engines. For the full list of DB instance
classes, and availability for your engine, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html}{DB Instance Class}
in the \emph{Amazon RDS User Guide.}

Default: Inherits from the source DB instance.}

\item{AvailabilityZone}{The Availability Zone (AZ) where the Read Replica will be created.

Default: A random, system-chosen Availability Zone in the endpoint\'s
AWS Region.

Example: \verb{us-east-1d}}

\item{Port}{The port number that the DB instance uses for connections.

Default: Inherits from the source DB instance

Valid Values: \code{1150-65535}}

\item{MultiAZ}{A value that indicates whether the Read Replica is in a Multi-AZ
deployment.

You can create a Read Replica as a Multi-AZ DB instance. RDS creates a
standby of your replica in another Availability Zone for failover
support for the replica. Creating your Read Replica as a Multi-AZ DB
instance is independent of whether the source database is a Multi-AZ DB
instance.}

\item{AutoMinorVersionUpgrade}{A value that indicates whether minor engine upgrades are applied
automatically to the Read Replica during the maintenance window.

Default: Inherits from the source DB instance}

\item{Iops}{The amount of Provisioned IOPS (input/output operations per second) to
be initially allocated for the DB instance.}

\item{OptionGroupName}{The option group the DB instance is associated with. If omitted, the
option group associated with the source instance is used.}

\item{DBParameterGroupName}{The name of the DB parameter group to associate with this DB instance.

If you do not specify a value for \code{DBParameterGroupName}, then Amazon
RDS uses the \code{DBParameterGroup} of source DB instance for a same region
Read Replica, or the default \code{DBParameterGroup} for the specified DB
engine for a cross region Read Replica.

Currently, specifying a parameter group for this operation is only
supported for Oracle DB instances.

Constraints:
\itemize{
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter
\item Can\'t end with a hyphen or contain two consecutive hyphens
}}

\item{PubliclyAccessible}{A value that indicates whether the DB instance is publicly accessible.
When the DB instance is publicly accessible, it is an Internet-facing
instance with a publicly resolvable DNS name, which resolves to a public
IP address. When the DB instance isn\'t publicly accessible, it is an
internal instance with a DNS name that resolves to a private IP address.
For more information, see CreateDBInstance.}

\item{Tags}{}

\item{DBSubnetGroupName}{Specifies a DB subnet group for the DB instance. The new DB instance is
created in the VPC associated with the DB subnet group. If no DB subnet
group is specified, then the new DB instance isn\'t created in a VPC.

Constraints:
\itemize{
\item Can only be specified if the source DB instance identifier specifies
a DB instance in another AWS Region.
\item If supplied, must match the name of an existing DBSubnetGroup.
\item The specified DB subnet group must be in the same AWS Region in
which the operation is running.
\item All Read Replicas in one AWS Region that are created from the same
source DB instance must either:\\>
\itemize{
\item Specify DB subnet groups from the same VPC. All these Read
Replicas are created in the same VPC.
\item Not specify a DB subnet group. All these Read Replicas are
created outside of any VPC.
}
}

Example: \code{mySubnetgroup}}

\item{VpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with the Read Replica.

Default: The default EC2 VPC security group for the DB subnet group\'s
VPC.}

\item{StorageType}{Specifies the storage type to be associated with the Read Replica.

Valid values: \code{standard | gp2 | io1}

If you specify \code{io1}, you must also include a value for the \code{Iops}
parameter.

Default: \code{io1} if the \code{Iops} parameter is specified, otherwise \code{gp2}}

\item{CopyTagsToSnapshot}{A value that indicates whether to copy all tags from the Read Replica to
snapshots of the Read Replica. By default, tags are not copied.}

\item{MonitoringInterval}{The interval, in seconds, between points when Enhanced Monitoring
metrics are collected for the Read Replica. To disable collecting
Enhanced Monitoring metrics, specify 0. The default is 0.

If \code{MonitoringRoleArn} is specified, then you must also set
\code{MonitoringInterval} to a value other than 0.

Valid Values: \verb{0, 1, 5, 10, 15, 30, 60}}

\item{MonitoringRoleArn}{The ARN for the IAM role that permits RDS to send enhanced monitoring
metrics to Amazon CloudWatch Logs. For example,
\code{arn:aws:iam:123456789012:role/emaccess}. For information on creating a
monitoring role, go to \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole}{To create an IAM role for Amazon RDS Enhanced Monitoring}
in the \emph{Amazon RDS User Guide}.

If \code{MonitoringInterval} is set to a value other than 0, then you must
supply a \code{MonitoringRoleArn} value.}

\item{KmsKeyId}{The AWS KMS key ID for an encrypted Read Replica. The KMS key ID is the
Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for
the KMS encryption key.

If you create an encrypted Read Replica in the same AWS Region as the
source DB instance, then you do not have to specify a value for this
parameter. The Read Replica is encrypted with the same KMS key as the
source DB instance.

If you create an encrypted Read Replica in a different AWS Region, then
you must specify a KMS key for the destination AWS Region. KMS
encryption keys are specific to the AWS Region that they are created in,
and you can\'t use encryption keys from one AWS Region in another AWS
Region.

You can\'t create an encrypted Read Replica from an unencrypted DB
instance.}

\item{PreSignedUrl}{The URL that contains a Signature Version 4 signed request for the
\code{CreateDBInstanceReadReplica} API action in the source AWS Region that
contains the source DB instance.

You must specify this parameter when you create an encrypted Read
Replica from another AWS Region by using the Amazon RDS API. Don\'t
specify \code{PreSignedUrl} when you are creating an encrypted Read Replica
in the same AWS Region.

The presigned URL must be a valid request for the
\code{CreateDBInstanceReadReplica} API action that can be executed in the
source AWS Region that contains the encrypted source DB instance. The
presigned URL request must contain the following parameter values:
\itemize{
\item \code{DestinationRegion} - The AWS Region that the encrypted Read Replica
is created in. This AWS Region is the same one where the
\code{CreateDBInstanceReadReplica} action is called that contains this
presigned URL.

For example, if you create an encrypted DB instance in the us-west-1
AWS Region, from a source DB instance in the us-east-2 AWS Region,
then you call the \code{CreateDBInstanceReadReplica} action in the
us-east-1 AWS Region and provide a presigned URL that contains a
call to the \code{CreateDBInstanceReadReplica} action in the us-west-2
AWS Region. For this example, the \code{DestinationRegion} in the
presigned URL must be set to the us-east-1 AWS Region.
\item \code{KmsKeyId} - The AWS KMS key identifier for the key to use to
encrypt the Read Replica in the destination AWS Region. This is the
same identifier for both the \code{CreateDBInstanceReadReplica} action
that is called in the destination AWS Region, and the action
contained in the presigned URL.
\item \code{SourceDBInstanceIdentifier} - The DB instance identifier for the
encrypted DB instance to be replicated. This identifier must be in
the Amazon Resource Name (ARN) format for the source AWS Region. For
example, if you are creating an encrypted Read Replica from a DB
instance in the us-west-2 AWS Region, then your
\code{SourceDBInstanceIdentifier} looks like the following example:
\code{arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115}.
}

To learn how to generate a Signature Version 4 signed request, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html}{Authenticating Requests: Using Query Parameters (AWS Signature Version 4)}
and \href{https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html}{Signature Version 4 Signing Process}.

If you are using an AWS SDK tool or the AWS CLI, you can specify
\code{SourceRegion} (or \code{--source-region} for the AWS CLI) instead of
specifying \code{PreSignedUrl} manually. Specifying \code{SourceRegion}
autogenerates a pre-signed URL that is a valid request for the operation
that can be executed in the source AWS Region.

If you supply a value for this operation\'s \code{SourceRegion} parameter, a
pre-signed URL will be calculated on your behalf.}

\item{EnableIAMDatabaseAuthentication}{A value that indicates whether to enable mapping of AWS Identity and
Access Management (IAM) accounts to database accounts. By default,
mapping is disabled. For information about the supported DB engines, see
CreateDBInstance.

For more information about IAM database authentication, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html}{IAM Database Authentication for MySQL and PostgreSQL}
in the \emph{Amazon RDS User Guide.}}

\item{EnablePerformanceInsights}{A value that indicates whether to enable Performance Insights for the
Read Replica.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html}{Using Amazon Performance Insights}
in the \emph{Amazon RDS User Guide}.}

\item{PerformanceInsightsKMSKeyId}{The AWS KMS key identifier for encryption of Performance Insights data.
The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or
the KMS key alias for the KMS encryption key.

If you do not specify a value for \code{PerformanceInsightsKMSKeyId}, then
Amazon RDS uses your default encryption key. AWS KMS creates the default
encryption key for your AWS account. Your AWS account has a different
default encryption key for each AWS Region.}

\item{PerformanceInsightsRetentionPeriod}{The amount of time, in days, to retain Performance Insights data. Valid
values are 7 or 731 (2 years).}

\item{EnableCloudwatchLogsExports}{The list of logs that the new DB instance is to export to CloudWatch
Logs. The values in the list depend on the DB engine being used. For
more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon RDS User Guide}.}

\item{ProcessorFeatures}{The number of CPU cores and the number of threads per core for the DB
instance class of the DB instance.}

\item{UseDefaultProcessorFeatures}{A value that indicates whether the DB instance class of the DB instance
uses its default processor features.}

\item{DeletionProtection}{A value that indicates whether the DB instance has deletion protection
enabled. The database can\'t be deleted when deletion protection is
enabled. By default, deletion protection is disabled. For more
information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html}{Deleting a DB Instance}.}

\item{Domain}{The Active Directory directory ID to create the DB instance in.

For Oracle DB instances, Amazon RDS can use Kerberos Authentication to
authenticate users that connect to the DB instance. For more
information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-kerberos.html}{Using Kerberos Authentication with Amazon RDS for Oracle}
in the \emph{Amazon RDS User Guide}.}

\item{DomainIAMRoleName}{Specify the name of the IAM role to be used when making API calls to the
Directory Service.}

\item{SourceRegion}{The ID of the region that contains the source for the read replica.}
}
\description{
Creates a new DB instance that acts as a Read Replica for an existing
source DB instance. You can create a Read Replica for a DB instance
running MySQL, MariaDB, Oracle, or PostgreSQL. For more information, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html}{Working with Read Replicas}
in the \emph{Amazon RDS User Guide}.
}
\details{
Amazon Aurora doesn\'t support this action. You must call the
\code{CreateDBInstance} action to create a DB instance for an Aurora DB
cluster.

All Read Replica DB instances are created with backups disabled. All
other DB instance attributes (including DB security groups and DB
parameter groups) are inherited from the source DB instance, except as
specified following.

Your source DB instance must have backup retention enabled.
}
\section{Request syntax}{
\preformatted{svc$create_db_instance_read_replica(
  DBInstanceIdentifier = "string",
  SourceDBInstanceIdentifier = "string",
  DBInstanceClass = "string",
  AvailabilityZone = "string",
  Port = 123,
  MultiAZ = TRUE|FALSE,
  AutoMinorVersionUpgrade = TRUE|FALSE,
  Iops = 123,
  OptionGroupName = "string",
  DBParameterGroupName = "string",
  PubliclyAccessible = TRUE|FALSE,
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  DBSubnetGroupName = "string",
  VpcSecurityGroupIds = list(
    "string"
  ),
  StorageType = "string",
  CopyTagsToSnapshot = TRUE|FALSE,
  MonitoringInterval = 123,
  MonitoringRoleArn = "string",
  KmsKeyId = "string",
  PreSignedUrl = "string",
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  EnablePerformanceInsights = TRUE|FALSE,
  PerformanceInsightsKMSKeyId = "string",
  PerformanceInsightsRetentionPeriod = 123,
  EnableCloudwatchLogsExports = list(
    "string"
  ),
  ProcessorFeatures = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  UseDefaultProcessorFeatures = TRUE|FALSE,
  DeletionProtection = TRUE|FALSE,
  Domain = "string",
  DomainIAMRoleName = "string",
  SourceRegion = "string"
)
}
}

\keyword{internal}
