% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_db_cluster_parameter_group}
\alias{rds_modify_db_cluster_parameter_group}
\title{Modifies the parameters of a DB cluster parameter group}
\usage{
rds_modify_db_cluster_parameter_group(DBClusterParameterGroupName,
  Parameters)
}
\arguments{
\item{DBClusterParameterGroupName}{[required] The name of the DB cluster parameter group to modify.}

\item{Parameters}{[required] A list of parameters in the DB cluster parameter group to modify.}
}
\description{
Modifies the parameters of a DB cluster parameter group. To modify more
than one parameter, submit a list of the following: \code{ParameterName},
\code{ParameterValue}, and \code{ApplyMethod}. A maximum of 20 parameters can be
modified in a single request.
}
\details{
For more information on Amazon Aurora, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html}{What Is Amazon Aurora?}
in the \emph{Amazon Aurora User Guide.}

Changes to dynamic parameters are applied immediately. Changes to static
parameters require a reboot without failover to the DB cluster
associated with the parameter group before the change can take effect.

After you create a DB cluster parameter group, you should wait at least
5 minutes before creating your first DB cluster that uses that DB
cluster parameter group as the default parameter group. This allows
Amazon RDS to fully complete the create action before the parameter
group is used as the default for a new DB cluster. This is especially
important for parameters that are critical when creating the default
database for a DB cluster, such as the character set for the default
database defined by the \code{character_set_database} parameter. You can use
the \emph{Parameter Groups} option of the \href{https://console.aws.amazon.com/rds/}{Amazon RDS console} or the
\code{DescribeDBClusterParameters} action to verify that your DB cluster
parameter group has been created or modified.

If the modified DB cluster parameter group is used by an Aurora
Serverless cluster, Aurora applies the update immediately. The cluster
restart might interrupt your workload. In that case, your application
must reopen any connections and retry any transactions that were active
when the parameter changes took effect.

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$modify_db_cluster_parameter_group(
  DBClusterParameterGroupName = "string",
  Parameters = list(
    list(
      ParameterName = "string",
      ParameterValue = "string",
      Description = "string",
      Source = "string",
      ApplyType = "string",
      DataType = "string",
      AllowedValues = "string",
      IsModifiable = TRUE|FALSE,
      MinimumEngineVersion = "string",
      ApplyMethod = "immediate"|"pending-reboot",
      SupportedEngineModes = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
