% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_db_cluster}
\alias{rds_modify_db_cluster}
\title{Modify a setting for an Amazon Aurora DB cluster}
\usage{
rds_modify_db_cluster(DBClusterIdentifier, NewDBClusterIdentifier,
  ApplyImmediately, BackupRetentionPeriod, DBClusterParameterGroupName,
  VpcSecurityGroupIds, Port, MasterUserPassword, OptionGroupName,
  PreferredBackupWindow, PreferredMaintenanceWindow,
  EnableIAMDatabaseAuthentication, BacktrackWindow,
  CloudwatchLogsExportConfiguration, EngineVersion,
  AllowMajorVersionUpgrade, DBInstanceParameterGroupName, Domain,
  DomainIAMRoleName, ScalingConfiguration, DeletionProtection,
  EnableHttpEndpoint, CopyTagsToSnapshot, EnableGlobalWriteForwarding)
}
\arguments{
\item{DBClusterIdentifier}{[required] The DB cluster identifier for the cluster being modified. This parameter
isn\'t case-sensitive.

Constraints: This identifier must match the identifier of an existing DB
cluster.}

\item{NewDBClusterIdentifier}{The new DB cluster identifier for the DB cluster when renaming a DB
cluster. This value is stored as a lowercase string.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens
\item The first character must be a letter
\item Can\'t end with a hyphen or contain two consecutive hyphens
}

Example: \code{my-cluster2}}

\item{ApplyImmediately}{A value that indicates whether the modifications in this request and any
pending modifications are asynchronously applied as soon as possible,
regardless of the \code{PreferredMaintenanceWindow} setting for the DB
cluster. If this parameter is disabled, changes to the DB cluster are
applied during the next maintenance window.

The \code{ApplyImmediately} parameter only affects the
\code{EnableIAMDatabaseAuthentication}, \code{MasterUserPassword}, and
\code{NewDBClusterIdentifier} values. If the \code{ApplyImmediately} parameter is
disabled, then changes to the \code{EnableIAMDatabaseAuthentication},
\code{MasterUserPassword}, and \code{NewDBClusterIdentifier} values are applied
during the next maintenance window. All other changes are applied
immediately, regardless of the value of the \code{ApplyImmediately}
parameter.

By default, this parameter is disabled.}

\item{BackupRetentionPeriod}{The number of days for which automated backups are retained. You must
specify a minimum value of 1.

Default: 1

Constraints:
\itemize{
\item Must be a value from 1 to 35
}}

\item{DBClusterParameterGroupName}{The name of the DB cluster parameter group to use for the DB cluster.}

\item{VpcSecurityGroupIds}{A list of VPC security groups that the DB cluster will belong to.}

\item{Port}{The port number on which the DB cluster accepts connections.

Constraints: Value must be \code{1150-65535}

Default: The same port as the original DB cluster.}

\item{MasterUserPassword}{The new password for the master database user. This password can contain
any printable ASCII character except \"/\", \"\"\", or \"@\".

Constraints: Must contain from 8 to 41 characters.}

\item{OptionGroupName}{A value that indicates that the DB cluster should be associated with the
specified option group. Changing this parameter doesn\'t result in an
outage except in the following case, and the change is applied during
the next maintenance window unless the \code{ApplyImmediately} is enabled for
this request. If the parameter change results in an option group that
enables OEM, this change can cause a brief (sub-second) period during
which new connections are rejected but existing connections are not
interrupted.

Permanent options can\'t be removed from an option group. The option
group can\'t be removed from a DB cluster once it is associated with a
DB cluster.}

\item{PreferredBackupWindow}{The daily time range during which automated backups are created if
automated backups are enabled, using the \code{BackupRetentionPeriod}
parameter.

The default is a 30-minute window selected at random from an 8-hour
block of time for each AWS Region. To see the time blocks available, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora}{Adjusting the Preferred DB Cluster Maintenance Window}
in the \emph{Amazon Aurora User Guide.}

Constraints:
\itemize{
\item Must be in the format \code{hh24:mi-hh24:mi}.
\item Must be in Universal Coordinated Time (UTC).
\item Must not conflict with the preferred maintenance window.
\item Must be at least 30 minutes.
}}

\item{PreferredMaintenanceWindow}{The weekly time range during which system maintenance can occur, in
Universal Coordinated Time (UTC).

Format: \code{ddd:hh24:mi-ddd:hh24:mi}

The default is a 30-minute window selected at random from an 8-hour
block of time for each AWS Region, occurring on a random day of the
week. To see the time blocks available, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora}{Adjusting the Preferred DB Cluster Maintenance Window}
in the \emph{Amazon Aurora User Guide.}

Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.

Constraints: Minimum 30-minute window.}

\item{EnableIAMDatabaseAuthentication}{A value that indicates whether to enable mapping of AWS Identity and
Access Management (IAM) accounts to database accounts. By default,
mapping is disabled.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html}{IAM Database Authentication}
in the \emph{Amazon Aurora User Guide.}}

\item{BacktrackWindow}{The target backtrack window, in seconds. To disable backtracking, set
this value to 0.

Currently, Backtrack is only supported for Aurora MySQL DB clusters.

Default: 0

Constraints:
\itemize{
\item If specified, this value must be set to a number from 0 to 259,200
(72 hours).
}}

\item{CloudwatchLogsExportConfiguration}{The configuration setting for the log types to be enabled for export to
CloudWatch Logs for a specific DB cluster.}

\item{EngineVersion}{The version number of the database engine to which you want to upgrade.
Changing this parameter results in an outage. The change is applied
during the next maintenance window unless \code{ApplyImmediately} is enabled.

To list all of the available engine versions for \code{aurora} (for MySQL
5.6-compatible Aurora), use the following command:

\verb{aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions\\\[\\\].EngineVersion"}

To list all of the available engine versions for \code{aurora-mysql} (for
MySQL 5.7-compatible Aurora), use the following command:

\verb{aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions\\\[\\\].EngineVersion"}

To list all of the available engine versions for \code{aurora-postgresql},
use the following command:

\verb{aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions\\\[\\\].EngineVersion"}}

\item{AllowMajorVersionUpgrade}{A value that indicates whether major version upgrades are allowed.

Constraints: You must allow major version upgrades when specifying a
value for the \code{EngineVersion} parameter that is a different major
version than the DB cluster\'s current version.}

\item{DBInstanceParameterGroupName}{The name of the DB parameter group to apply to all instances of the DB
cluster.

When you apply a parameter group using the
\code{DBInstanceParameterGroupName} parameter, the DB cluster isn\'t rebooted
automatically. Also, parameter changes aren\'t applied during the next
maintenance window but instead are applied immediately.

Default: The existing name setting

Constraints:
\itemize{
\item The DB parameter group must be in the same DB parameter group family
as this DB cluster.
\item The \code{DBInstanceParameterGroupName} parameter is only valid in
combination with the \code{AllowMajorVersionUpgrade} parameter.
}}

\item{Domain}{The Active Directory directory ID to move the DB cluster to. Specify
\code{none} to remove the cluster from its current domain. The domain must be
created prior to this operation.}

\item{DomainIAMRoleName}{Specify the name of the IAM role to be used when making API calls to the
Directory Service.}

\item{ScalingConfiguration}{The scaling properties of the DB cluster. You can only modify scaling
properties for DB clusters in \code{serverless} DB engine mode.}

\item{DeletionProtection}{A value that indicates whether the DB cluster has deletion protection
enabled. The database can\'t be deleted when deletion protection is
enabled. By default, deletion protection is disabled.}

\item{EnableHttpEndpoint}{A value that indicates whether to enable the HTTP endpoint for an Aurora
Serverless DB cluster. By default, the HTTP endpoint is disabled.

When enabled, the HTTP endpoint provides a connectionless web service
API for running SQL queries on the Aurora Serverless DB cluster. You can
also query your database from inside the RDS console with the query
editor.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html}{Using the Data API for Aurora Serverless}
in the \emph{Amazon Aurora User Guide}.}

\item{CopyTagsToSnapshot}{A value that indicates whether to copy all tags from the DB cluster to
snapshots of the DB cluster. The default is not to copy them.}

\item{EnableGlobalWriteForwarding}{A value that indicates whether to enable write operations to be
forwarded from this cluster to the primary cluster in an Aurora global
database. The resulting changes are replicated back to this cluster.
This parameter only applies to DB clusters that are secondary clusters
in an Aurora global database. By default, Aurora disallows write
operations for secondary clusters.}
}
\description{
Modify a setting for an Amazon Aurora DB cluster. You can change one or
more database configuration parameters by specifying these parameters
and the new values in the request. For more information on Amazon
Aurora, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html}{What Is Amazon Aurora?}
in the \emph{Amazon Aurora User Guide.}
}
\details{
This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$modify_db_cluster(
  DBClusterIdentifier = "string",
  NewDBClusterIdentifier = "string",
  ApplyImmediately = TRUE|FALSE,
  BackupRetentionPeriod = 123,
  DBClusterParameterGroupName = "string",
  VpcSecurityGroupIds = list(
    "string"
  ),
  Port = 123,
  MasterUserPassword = "string",
  OptionGroupName = "string",
  PreferredBackupWindow = "string",
  PreferredMaintenanceWindow = "string",
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  BacktrackWindow = 123,
  CloudwatchLogsExportConfiguration = list(
    EnableLogTypes = list(
      "string"
    ),
    DisableLogTypes = list(
      "string"
    )
  ),
  EngineVersion = "string",
  AllowMajorVersionUpgrade = TRUE|FALSE,
  DBInstanceParameterGroupName = "string",
  Domain = "string",
  DomainIAMRoleName = "string",
  ScalingConfiguration = list(
    MinCapacity = 123,
    MaxCapacity = 123,
    AutoPause = TRUE|FALSE,
    SecondsUntilAutoPause = 123,
    TimeoutAction = "string"
  ),
  DeletionProtection = TRUE|FALSE,
  EnableHttpEndpoint = TRUE|FALSE,
  CopyTagsToSnapshot = TRUE|FALSE,
  EnableGlobalWriteForwarding = TRUE|FALSE
)
}
}

\keyword{internal}
