% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeformation_operations.R
\name{lakeformation_list_lf_tags}
\alias{lakeformation_list_lf_tags}
\title{Lists LF-tags that the requester has permission to view}
\usage{
lakeformation_list_lf_tags(
  CatalogId = NULL,
  ResourceShareType = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{CatalogId}{The identifier for the Data Catalog. By default, the account ID. The
Data Catalog is the persistent metadata store. It contains database
definitions, table definitions, and other control information to manage
your Lake Formation environment.}

\item{ResourceShareType}{If resource share type is \code{ALL}, returns both in-account LF-tags and
shared LF-tags that the requester has permission to view. If resource
share type is \code{FOREIGN}, returns all share LF-tags that the requester
can view. If no resource share type is passed, lists LF-tags in the
given catalog ID that the requester has permission to view.}

\item{MaxResults}{The maximum number of results to return.}

\item{NextToken}{A continuation token, if this is not the first call to retrieve this
list.}
}
\description{
Lists LF-tags that the requester has permission to view.

See \url{https://paws-r.github.io/docs/lakeformation/list_lf_tags.html} for full documentation.
}
\keyword{internal}
