% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_db_subnet_group}
\alias{rds_modify_db_subnet_group}
\title{Modifies an existing DB subnet group}
\usage{
rds_modify_db_subnet_group(
  DBSubnetGroupName,
  DBSubnetGroupDescription = NULL,
  SubnetIds
)
}
\arguments{
\item{DBSubnetGroupName}{[required] The name for the DB subnet group. This value is stored as a lowercase
string. You can't modify the default subnet group.

Constraints: Must match the name of an existing DBSubnetGroup. Must not
be default.

Example: \code{mydbsubnetgroup}}

\item{DBSubnetGroupDescription}{The description for the DB subnet group.}

\item{SubnetIds}{[required] The EC2 subnet IDs for the DB subnet group.}
}
\description{
Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Web Services Region.

See \url{https://paws-r.github.io/docs/rds/modify_db_subnet_group.html} for full documentation.
}
\keyword{internal}
