% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdsdataservice_operations.R
\name{rdsdataservice_execute_statement}
\alias{rdsdataservice_execute_statement}
\title{Runs a SQL statement against a database}
\usage{
rdsdataservice_execute_statement(
  continueAfterTimeout = NULL,
  database = NULL,
  formatRecordsAs = NULL,
  includeResultMetadata = NULL,
  parameters = NULL,
  resourceArn,
  resultSetOptions = NULL,
  schema = NULL,
  secretArn,
  sql,
  transactionId = NULL
)
}
\arguments{
\item{continueAfterTimeout}{A value that indicates whether to continue running the statement after
the call times out. By default, the statement stops running when the
call times out.

For DDL statements, we recommend continuing to run the statement after
the call times out. When a DDL statement terminates before it is
finished running, it can result in errors and possibly corrupted data
structures.}

\item{database}{The name of the database.}

\item{formatRecordsAs}{A value that indicates whether to format the result set as a single JSON
string. This parameter only applies to \code{SELECT} statements and is
ignored for other types of statements. Allowed values are \code{NONE} and
\code{JSON}. The default value is \code{NONE}. The result is returned in the
\code{formattedRecords} field.

For usage information about the JSON format for result sets, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html}{Using the Data API}
in the \emph{Amazon Aurora User Guide}.}

\item{includeResultMetadata}{A value that indicates whether to include metadata in the results.}

\item{parameters}{The parameters for the SQL statement.

Array parameters are not supported.}

\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.}

\item{resultSetOptions}{Options that control how the result set is returned.}

\item{schema}{The name of the database schema.

Currently, the \code{schema} parameter isn't supported.}

\item{secretArn}{[required] The ARN of the secret that enables access to the DB cluster. Enter the
database user name and password for the credentials in the secret.

For information about creating the secret, see \href{https://docs.aws.amazon.com/secretsmanager/latest/userguide/create_database_secret.html}{Create a database secret}.}

\item{sql}{[required] The SQL statement to run.}

\item{transactionId}{The identifier of a transaction that was started by using the
\code{\link[=rdsdataservice_begin_transaction]{begin_transaction}} operation.
Specify the transaction ID of the transaction that you want to include
the SQL statement in.

If the SQL statement is not part of a transaction, don't set this
parameter.}
}
\description{
Runs a SQL statement against a database.

See \url{https://paws-r.github.io/docs/rdsdataservice/execute_statement.html} for full documentation.
}
\keyword{internal}
