% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftserverless_operations.R
\name{redshiftserverless_create_workgroup}
\alias{redshiftserverless_create_workgroup}
\title{Creates an workgroup in Amazon Redshift Serverless}
\usage{
redshiftserverless_create_workgroup(
  baseCapacity = NULL,
  configParameters = NULL,
  enhancedVpcRouting = NULL,
  namespaceName,
  publiclyAccessible = NULL,
  securityGroupIds = NULL,
  subnetIds = NULL,
  tags = NULL,
  workgroupName
)
}
\arguments{
\item{baseCapacity}{The base data warehouse capacity of the workgroup in Redshift Processing
Units (RPUs).}

\item{configParameters}{An array of parameters to set for more control over a serverless
database. The options are \code{datestyle}, \code{enable_user_activity_logging},
\code{query_group}, \code{search_path}, and \code{max_query_execution_time}.}

\item{enhancedVpcRouting}{The value that specifies whether to turn on enhanced virtual private
cloud (VPC) routing, which forces Amazon Redshift Serverless to route
traffic through your VPC instead of over the internet.}

\item{namespaceName}{[required] The name of the namespace to associate with the workgroup.}

\item{publiclyAccessible}{A value that specifies whether the workgroup can be accessed from a
public network.}

\item{securityGroupIds}{An array of security group IDs to associate with the workgroup.}

\item{subnetIds}{An array of VPC subnet IDs to associate with the workgroup.}

\item{tags}{A array of tag instances.}

\item{workgroupName}{[required] The name of the created workgroup.}
}
\description{
Creates an workgroup in Amazon Redshift Serverless.

See \url{https://paws-r.github.io/docs/redshiftserverless/create_workgroup.html} for full documentation.
}
\keyword{internal}
