% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_remove_role_from_db_cluster}
\alias{neptune_remove_role_from_db_cluster}
\title{Disassociates an Identity and Access Management (IAM) role from a DB
cluster}
\usage{
neptune_remove_role_from_db_cluster(
  DBClusterIdentifier,
  RoleArn,
  FeatureName = NULL
)
}
\arguments{
\item{DBClusterIdentifier}{[required] The name of the DB cluster to disassociate the IAM role from.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role to disassociate from the
DB cluster, for example
\verb{arn:aws:iam::123456789012:role/NeptuneAccessRole}.}

\item{FeatureName}{The name of the feature for the DB cluster that the IAM role is to be
disassociated from. For the list of supported feature names, see
\code{\link[=neptune_describe_db_engine_versions]{describe_db_engine_versions}}.}
}
\description{
Disassociates an Identity and Access Management (IAM) role from a DB cluster.

See \url{https://www.paws-r-sdk.com/docs/neptune_remove_role_from_db_cluster/} for full documentation.
}
\keyword{internal}
