% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyspaces_operations.R
\name{keyspaces_update_table}
\alias{keyspaces_update_table}
\title{Adds new columns to the table or updates one of the table's settings,
for example capacity mode, auto scaling, encryption, point-in-time
recovery, or ttl settings}
\usage{
keyspaces_update_table(
  keyspaceName,
  tableName,
  addColumns = NULL,
  capacitySpecification = NULL,
  encryptionSpecification = NULL,
  pointInTimeRecovery = NULL,
  ttl = NULL,
  defaultTimeToLive = NULL,
  clientSideTimestamps = NULL,
  autoScalingSpecification = NULL,
  replicaSpecifications = NULL
)
}
\arguments{
\item{keyspaceName}{[required] The name of the keyspace the specified table is stored in.}

\item{tableName}{[required] The name of the table.}

\item{addColumns}{For each column to be added to the specified table:
\itemize{
\item \code{name} - The name of the column.
\item \code{type} - An Amazon Keyspaces data type. For more information, see
\href{https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types}{Data types}
in the \emph{Amazon Keyspaces Developer Guide}.
}}

\item{capacitySpecification}{Modifies the read/write throughput capacity mode for the table. The
options are:
\itemize{
\item \code{throughputMode:PAY_PER_REQUEST} and
\item \code{throughputMode:PROVISIONED} - Provisioned capacity mode requires
\code{readCapacityUnits} and \code{writeCapacityUnits} as input.
}

The default is \code{throughput_mode:PAY_PER_REQUEST}.

For more information, see \href{https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html}{Read/write capacity modes}
in the \emph{Amazon Keyspaces Developer Guide}.}

\item{encryptionSpecification}{Modifies the encryption settings of the table. You can choose one of the
following KMS key (KMS key):
\itemize{
\item \code{type:AWS_OWNED_KMS_KEY} - This key is owned by Amazon Keyspaces.
\item \code{type:CUSTOMER_MANAGED_KMS_KEY} - This key is stored in your account
and is created, owned, and managed by you. This option requires the
\code{kms_key_identifier} of the KMS key in Amazon Resource Name (ARN)
format as input.
}

The default is \code{AWS_OWNED_KMS_KEY}.

For more information, see \href{https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html}{Encryption at rest}
in the \emph{Amazon Keyspaces Developer Guide}.}

\item{pointInTimeRecovery}{Modifies the \code{pointInTimeRecovery} settings of the table. The options
are:
\itemize{
\item \code{status=ENABLED}
\item \code{status=DISABLED}
}

If it's not specified, the default is \code{status=DISABLED}.

For more information, see \href{https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html}{Point-in-time recovery}
in the \emph{Amazon Keyspaces Developer Guide}.}

\item{ttl}{Modifies Time to Live custom settings for the table. The options are:
\itemize{
\item \code{status:enabled}
\item \code{status:disabled}
}

The default is \code{status:disabled}. After \code{ttl} is enabled, you can't
disable it for the table.

For more information, see \href{https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html}{Expiring data by using Amazon Keyspaces Time to Live (TTL)}
in the \emph{Amazon Keyspaces Developer Guide}.}

\item{defaultTimeToLive}{The default Time to Live setting in seconds for the table.

For more information, see \href{https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl}{Setting the default TTL value for a table}
in the \emph{Amazon Keyspaces Developer Guide}.}

\item{clientSideTimestamps}{Enables client-side timestamps for the table. By default, the setting is
disabled. You can enable client-side timestamps with the following
option:
\itemize{
\item \code{status: "enabled"}
}

Once client-side timestamps are enabled for a table, this setting cannot
be disabled.}

\item{autoScalingSpecification}{The optional auto scaling settings to update for a table in provisioned
capacity mode. Specifies if the service can manage throughput capacity
of a provisioned table automatically on your behalf. Amazon Keyspaces
auto scaling helps you provision throughput capacity for variable
workloads efficiently by increasing and decreasing your table's read and
write capacity automatically in response to application traffic.

If auto scaling is already enabled for the table, you can use
\code{\link[=keyspaces_update_table]{update_table}} to update the minimum and
maximum values or the auto scaling policy settings independently.

For more information, see \href{https://docs.aws.amazon.com/keyspaces/latest/devguide/autoscaling.html}{Managing throughput capacity automatically with Amazon Keyspaces auto scaling}
in the \emph{Amazon Keyspaces Developer Guide}.}

\item{replicaSpecifications}{The Region specific settings of a multi-Regional table.}
}
\description{
Adds new columns to the table or updates one of the table's settings, for example capacity mode, auto scaling, encryption, point-in-time recovery, or ttl settings. Note that you can only update one specific table setting per update operation.

See \url{https://www.paws-r-sdk.com/docs/keyspaces_update_table/} for full documentation.
}
\keyword{internal}
