% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_remove_role_from_db_cluster}
\alias{rds_remove_role_from_db_cluster}
\title{Removes the asssociation of an Amazon Web Services Identity and Access
Management (IAM) role from a DB cluster}
\usage{
rds_remove_role_from_db_cluster(
  DBClusterIdentifier,
  RoleArn,
  FeatureName = NULL
)
}
\arguments{
\item{DBClusterIdentifier}{[required] The name of the DB cluster to disassociate the IAM role from.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role to disassociate from the
Aurora DB cluster, for example
\verb{arn:aws:iam::123456789012:role/AuroraAccessRole}.}

\item{FeatureName}{The name of the feature for the DB cluster that the IAM role is to be
disassociated from. For information about supported feature names, see
DBEngineVersion.}
}
\description{
Removes the asssociation of an Amazon Web Services Identity and Access Management (IAM) role from a DB cluster.

See \url{https://www.paws-r-sdk.com/docs/rds_remove_role_from_db_cluster/} for full documentation.
}
\keyword{internal}
