# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include xray_service.R
NULL

#' Retrieves a list of traces specified by ID
#'
#' @description
#' Retrieves a list of traces specified by ID. Each trace is a collection of segment documents that originates from a single request. Use [`get_trace_summaries`][xray_get_trace_summaries] to get a list of trace IDs.
#'
#' See [https://paws-r.github.io/docs/xray/batch_get_traces.html](https://paws-r.github.io/docs/xray/batch_get_traces.html) for full documentation.
#'
#' @param TraceIds &#91;required&#93; Specify the trace IDs of requests for which to retrieve segments.
#' @param NextToken Pagination token.
#'
#' @keywords internal
#'
#' @rdname xray_batch_get_traces
xray_batch_get_traces <- function(TraceIds, NextToken = NULL) {
  op <- new_operation(
    name = "BatchGetTraces",
    http_method = "POST",
    http_path = "/Traces",
    paginator = list()
  )
  input <- .xray$batch_get_traces_input(TraceIds = TraceIds, NextToken = NextToken)
  output <- .xray$batch_get_traces_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$batch_get_traces <- xray_batch_get_traces

#' Creates a group resource with a name and a filter expression
#'
#' @description
#' Creates a group resource with a name and a filter expression.
#'
#' See [https://paws-r.github.io/docs/xray/create_group.html](https://paws-r.github.io/docs/xray/create_group.html) for full documentation.
#'
#' @param GroupName &#91;required&#93; The case-sensitive name of the new group. Default is a reserved name and
#' names must be unique.
#' @param FilterExpression The filter expression defining criteria by which to group traces.
#' @param InsightsConfiguration The structure containing configurations related to insights.
#' 
#' -   The InsightsEnabled boolean can be set to true to enable insights
#'     for the new group or false to disable insights for the new group.
#' 
#' -   The NotifcationsEnabled boolean can be set to true to enable
#'     insights notifications for the new group. Notifications may only be
#'     enabled on a group with InsightsEnabled set to true.
#' @param Tags A map that contains one or more tag keys and tag values to attach to an
#' X-Ray group. For more information about ways to use tags, see [Tagging
#' Amazon Web Services
#' resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
#' in the *Amazon Web Services General Reference*.
#' 
#' The following restrictions apply to tags:
#' 
#' -   Maximum number of user-applied tags per resource: 50
#' 
#' -   Maximum tag key length: 128 Unicode characters
#' 
#' -   Maximum tag value length: 256 Unicode characters
#' 
#' -   Valid values for key and value: a-z, A-Z, 0-9, space, and the
#'     following characters: _ . : / = + - and @@
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Don't use `aws:` as a prefix for keys; it's reserved for Amazon Web
#'     Services use.
#'
#' @keywords internal
#'
#' @rdname xray_create_group
xray_create_group <- function(GroupName, FilterExpression = NULL, InsightsConfiguration = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateGroup",
    http_method = "POST",
    http_path = "/CreateGroup",
    paginator = list()
  )
  input <- .xray$create_group_input(GroupName = GroupName, FilterExpression = FilterExpression, InsightsConfiguration = InsightsConfiguration, Tags = Tags)
  output <- .xray$create_group_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$create_group <- xray_create_group

#' Creates a rule to control sampling behavior for instrumented
#' applications
#'
#' @description
#' Creates a rule to control sampling behavior for instrumented applications. Services retrieve rules with [`get_sampling_rules`][xray_get_sampling_rules], and evaluate each rule in ascending order of *priority* for each request. If a rule matches, the service records a trace, borrowing it from the reservoir size. After 10 seconds, the service reports back to X-Ray with [`get_sampling_targets`][xray_get_sampling_targets] to get updated versions of each in-use rule. The updated rule contains a trace quota that the service can use instead of borrowing from the reservoir.
#'
#' See [https://paws-r.github.io/docs/xray/create_sampling_rule.html](https://paws-r.github.io/docs/xray/create_sampling_rule.html) for full documentation.
#'
#' @param SamplingRule &#91;required&#93; The rule definition.
#' @param Tags A map that contains one or more tag keys and tag values to attach to an
#' X-Ray sampling rule. For more information about ways to use tags, see
#' [Tagging Amazon Web Services
#' resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
#' in the *Amazon Web Services General Reference*.
#' 
#' The following restrictions apply to tags:
#' 
#' -   Maximum number of user-applied tags per resource: 50
#' 
#' -   Maximum tag key length: 128 Unicode characters
#' 
#' -   Maximum tag value length: 256 Unicode characters
#' 
#' -   Valid values for key and value: a-z, A-Z, 0-9, space, and the
#'     following characters: _ . : / = + - and @@
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Don't use `aws:` as a prefix for keys; it's reserved for Amazon Web
#'     Services use.
#'
#' @keywords internal
#'
#' @rdname xray_create_sampling_rule
xray_create_sampling_rule <- function(SamplingRule, Tags = NULL) {
  op <- new_operation(
    name = "CreateSamplingRule",
    http_method = "POST",
    http_path = "/CreateSamplingRule",
    paginator = list()
  )
  input <- .xray$create_sampling_rule_input(SamplingRule = SamplingRule, Tags = Tags)
  output <- .xray$create_sampling_rule_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$create_sampling_rule <- xray_create_sampling_rule

#' Deletes a group resource
#'
#' @description
#' Deletes a group resource.
#'
#' See [https://paws-r.github.io/docs/xray/delete_group.html](https://paws-r.github.io/docs/xray/delete_group.html) for full documentation.
#'
#' @param GroupName The case-sensitive name of the group.
#' @param GroupARN The ARN of the group that was generated on creation.
#'
#' @keywords internal
#'
#' @rdname xray_delete_group
xray_delete_group <- function(GroupName = NULL, GroupARN = NULL) {
  op <- new_operation(
    name = "DeleteGroup",
    http_method = "POST",
    http_path = "/DeleteGroup",
    paginator = list()
  )
  input <- .xray$delete_group_input(GroupName = GroupName, GroupARN = GroupARN)
  output <- .xray$delete_group_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$delete_group <- xray_delete_group

#' Deletes a sampling rule
#'
#' @description
#' Deletes a sampling rule.
#'
#' See [https://paws-r.github.io/docs/xray/delete_sampling_rule.html](https://paws-r.github.io/docs/xray/delete_sampling_rule.html) for full documentation.
#'
#' @param RuleName The name of the sampling rule. Specify a rule by either name or ARN, but
#' not both.
#' @param RuleARN The ARN of the sampling rule. Specify a rule by either name or ARN, but
#' not both.
#'
#' @keywords internal
#'
#' @rdname xray_delete_sampling_rule
xray_delete_sampling_rule <- function(RuleName = NULL, RuleARN = NULL) {
  op <- new_operation(
    name = "DeleteSamplingRule",
    http_method = "POST",
    http_path = "/DeleteSamplingRule",
    paginator = list()
  )
  input <- .xray$delete_sampling_rule_input(RuleName = RuleName, RuleARN = RuleARN)
  output <- .xray$delete_sampling_rule_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$delete_sampling_rule <- xray_delete_sampling_rule

#' Retrieves the current encryption configuration for X-Ray data
#'
#' @description
#' Retrieves the current encryption configuration for X-Ray data.
#'
#' See [https://paws-r.github.io/docs/xray/get_encryption_config.html](https://paws-r.github.io/docs/xray/get_encryption_config.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname xray_get_encryption_config
xray_get_encryption_config <- function() {
  op <- new_operation(
    name = "GetEncryptionConfig",
    http_method = "POST",
    http_path = "/EncryptionConfig",
    paginator = list()
  )
  input <- .xray$get_encryption_config_input()
  output <- .xray$get_encryption_config_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_encryption_config <- xray_get_encryption_config

#' Retrieves group resource details
#'
#' @description
#' Retrieves group resource details.
#'
#' See [https://paws-r.github.io/docs/xray/get_group.html](https://paws-r.github.io/docs/xray/get_group.html) for full documentation.
#'
#' @param GroupName The case-sensitive name of the group.
#' @param GroupARN The ARN of the group that was generated on creation.
#'
#' @keywords internal
#'
#' @rdname xray_get_group
xray_get_group <- function(GroupName = NULL, GroupARN = NULL) {
  op <- new_operation(
    name = "GetGroup",
    http_method = "POST",
    http_path = "/GetGroup",
    paginator = list()
  )
  input <- .xray$get_group_input(GroupName = GroupName, GroupARN = GroupARN)
  output <- .xray$get_group_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_group <- xray_get_group

#' Retrieves all active group details
#'
#' @description
#' Retrieves all active group details.
#'
#' See [https://paws-r.github.io/docs/xray/get_groups.html](https://paws-r.github.io/docs/xray/get_groups.html) for full documentation.
#'
#' @param NextToken Pagination token.
#'
#' @keywords internal
#'
#' @rdname xray_get_groups
xray_get_groups <- function(NextToken = NULL) {
  op <- new_operation(
    name = "GetGroups",
    http_method = "POST",
    http_path = "/Groups",
    paginator = list()
  )
  input <- .xray$get_groups_input(NextToken = NextToken)
  output <- .xray$get_groups_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_groups <- xray_get_groups

#' Retrieves the summary information of an insight
#'
#' @description
#' Retrieves the summary information of an insight. This includes impact to clients and root cause services, the top anomalous services, the category, the state of the insight, and the start and end time of the insight.
#'
#' See [https://paws-r.github.io/docs/xray/get_insight.html](https://paws-r.github.io/docs/xray/get_insight.html) for full documentation.
#'
#' @param InsightId &#91;required&#93; The insight's unique identifier. Use the GetInsightSummaries action to
#' retrieve an InsightId.
#'
#' @keywords internal
#'
#' @rdname xray_get_insight
xray_get_insight <- function(InsightId) {
  op <- new_operation(
    name = "GetInsight",
    http_method = "POST",
    http_path = "/Insight",
    paginator = list()
  )
  input <- .xray$get_insight_input(InsightId = InsightId)
  output <- .xray$get_insight_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_insight <- xray_get_insight

#' X-Ray reevaluates insights periodically until they're resolved, and
#' records each intermediate state as an event
#'
#' @description
#' X-Ray reevaluates insights periodically until they're resolved, and records each intermediate state as an event. You can review an insight's events in the Impact Timeline on the Inspect page in the X-Ray console.
#'
#' See [https://paws-r.github.io/docs/xray/get_insight_events.html](https://paws-r.github.io/docs/xray/get_insight_events.html) for full documentation.
#'
#' @param InsightId &#91;required&#93; The insight's unique identifier. Use the GetInsightSummaries action to
#' retrieve an InsightId.
#' @param MaxResults Used to retrieve at most the specified value of events.
#' @param NextToken Specify the pagination token returned by a previous request to retrieve
#' the next page of events.
#'
#' @keywords internal
#'
#' @rdname xray_get_insight_events
xray_get_insight_events <- function(InsightId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetInsightEvents",
    http_method = "POST",
    http_path = "/InsightEvents",
    paginator = list()
  )
  input <- .xray$get_insight_events_input(InsightId = InsightId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .xray$get_insight_events_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_insight_events <- xray_get_insight_events

#' Retrieves a service graph structure filtered by the specified insight
#'
#' @description
#' Retrieves a service graph structure filtered by the specified insight. The service graph is limited to only structural information. For a complete service graph, use this API with the GetServiceGraph API.
#'
#' See [https://paws-r.github.io/docs/xray/get_insight_impact_graph.html](https://paws-r.github.io/docs/xray/get_insight_impact_graph.html) for full documentation.
#'
#' @param InsightId &#91;required&#93; The insight's unique identifier. Use the GetInsightSummaries action to
#' retrieve an InsightId.
#' @param StartTime &#91;required&#93; The estimated start time of the insight, in Unix time seconds. The
#' StartTime is inclusive of the value provided and can't be more than 30
#' days old.
#' @param EndTime &#91;required&#93; The estimated end time of the insight, in Unix time seconds. The EndTime
#' is exclusive of the value provided. The time range between the start
#' time and end time can't be more than six hours.
#' @param NextToken Specify the pagination token returned by a previous request to retrieve
#' the next page of results.
#'
#' @keywords internal
#'
#' @rdname xray_get_insight_impact_graph
xray_get_insight_impact_graph <- function(InsightId, StartTime, EndTime, NextToken = NULL) {
  op <- new_operation(
    name = "GetInsightImpactGraph",
    http_method = "POST",
    http_path = "/InsightImpactGraph",
    paginator = list()
  )
  input <- .xray$get_insight_impact_graph_input(InsightId = InsightId, StartTime = StartTime, EndTime = EndTime, NextToken = NextToken)
  output <- .xray$get_insight_impact_graph_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_insight_impact_graph <- xray_get_insight_impact_graph

#' Retrieves the summaries of all insights in the specified group matching
#' the provided filter values
#'
#' @description
#' Retrieves the summaries of all insights in the specified group matching the provided filter values.
#'
#' See [https://paws-r.github.io/docs/xray/get_insight_summaries.html](https://paws-r.github.io/docs/xray/get_insight_summaries.html) for full documentation.
#'
#' @param States The list of insight states.
#' @param GroupARN The Amazon Resource Name (ARN) of the group. Required if the GroupName
#' isn't provided.
#' @param GroupName The name of the group. Required if the GroupARN isn't provided.
#' @param StartTime &#91;required&#93; The beginning of the time frame in which the insights started. The start
#' time can't be more than 30 days old.
#' @param EndTime &#91;required&#93; The end of the time frame in which the insights ended. The end time
#' can't be more than 30 days old.
#' @param MaxResults The maximum number of results to display.
#' @param NextToken Pagination token.
#'
#' @keywords internal
#'
#' @rdname xray_get_insight_summaries
xray_get_insight_summaries <- function(States = NULL, GroupARN = NULL, GroupName = NULL, StartTime, EndTime, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetInsightSummaries",
    http_method = "POST",
    http_path = "/InsightSummaries",
    paginator = list()
  )
  input <- .xray$get_insight_summaries_input(States = States, GroupARN = GroupARN, GroupName = GroupName, StartTime = StartTime, EndTime = EndTime, MaxResults = MaxResults, NextToken = NextToken)
  output <- .xray$get_insight_summaries_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_insight_summaries <- xray_get_insight_summaries

#' Retrieves all sampling rules
#'
#' @description
#' Retrieves all sampling rules.
#'
#' See [https://paws-r.github.io/docs/xray/get_sampling_rules.html](https://paws-r.github.io/docs/xray/get_sampling_rules.html) for full documentation.
#'
#' @param NextToken Pagination token.
#'
#' @keywords internal
#'
#' @rdname xray_get_sampling_rules
xray_get_sampling_rules <- function(NextToken = NULL) {
  op <- new_operation(
    name = "GetSamplingRules",
    http_method = "POST",
    http_path = "/GetSamplingRules",
    paginator = list()
  )
  input <- .xray$get_sampling_rules_input(NextToken = NextToken)
  output <- .xray$get_sampling_rules_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_sampling_rules <- xray_get_sampling_rules

#' Retrieves information about recent sampling results for all sampling
#' rules
#'
#' @description
#' Retrieves information about recent sampling results for all sampling rules.
#'
#' See [https://paws-r.github.io/docs/xray/get_sampling_statistic_summaries.html](https://paws-r.github.io/docs/xray/get_sampling_statistic_summaries.html) for full documentation.
#'
#' @param NextToken Pagination token.
#'
#' @keywords internal
#'
#' @rdname xray_get_sampling_statistic_summaries
xray_get_sampling_statistic_summaries <- function(NextToken = NULL) {
  op <- new_operation(
    name = "GetSamplingStatisticSummaries",
    http_method = "POST",
    http_path = "/SamplingStatisticSummaries",
    paginator = list()
  )
  input <- .xray$get_sampling_statistic_summaries_input(NextToken = NextToken)
  output <- .xray$get_sampling_statistic_summaries_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_sampling_statistic_summaries <- xray_get_sampling_statistic_summaries

#' Requests a sampling quota for rules that the service is using to sample
#' requests
#'
#' @description
#' Requests a sampling quota for rules that the service is using to sample requests.
#'
#' See [https://paws-r.github.io/docs/xray/get_sampling_targets.html](https://paws-r.github.io/docs/xray/get_sampling_targets.html) for full documentation.
#'
#' @param SamplingStatisticsDocuments &#91;required&#93; Information about rules that the service is using to sample requests.
#'
#' @keywords internal
#'
#' @rdname xray_get_sampling_targets
xray_get_sampling_targets <- function(SamplingStatisticsDocuments) {
  op <- new_operation(
    name = "GetSamplingTargets",
    http_method = "POST",
    http_path = "/SamplingTargets",
    paginator = list()
  )
  input <- .xray$get_sampling_targets_input(SamplingStatisticsDocuments = SamplingStatisticsDocuments)
  output <- .xray$get_sampling_targets_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_sampling_targets <- xray_get_sampling_targets

#' Retrieves a document that describes services that process incoming
#' requests, and downstream services that they call as a result
#'
#' @description
#' Retrieves a document that describes services that process incoming requests, and downstream services that they call as a result. Root services process incoming requests and make calls to downstream services. Root services are applications that use the [Amazon Web Services X-Ray SDK](https://docs.aws.amazon.com/xray/index.html). Downstream services can be other applications, Amazon Web Services resources, HTTP web APIs, or SQL databases.
#'
#' See [https://paws-r.github.io/docs/xray/get_service_graph.html](https://paws-r.github.io/docs/xray/get_service_graph.html) for full documentation.
#'
#' @param StartTime &#91;required&#93; The start of the time frame for which to generate a graph.
#' @param EndTime &#91;required&#93; The end of the timeframe for which to generate a graph.
#' @param GroupName The name of a group based on which you want to generate a graph.
#' @param GroupARN The Amazon Resource Name (ARN) of a group based on which you want to
#' generate a graph.
#' @param NextToken Pagination token.
#'
#' @keywords internal
#'
#' @rdname xray_get_service_graph
xray_get_service_graph <- function(StartTime, EndTime, GroupName = NULL, GroupARN = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetServiceGraph",
    http_method = "POST",
    http_path = "/ServiceGraph",
    paginator = list()
  )
  input <- .xray$get_service_graph_input(StartTime = StartTime, EndTime = EndTime, GroupName = GroupName, GroupARN = GroupARN, NextToken = NextToken)
  output <- .xray$get_service_graph_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_service_graph <- xray_get_service_graph

#' Get an aggregation of service statistics defined by a specific time
#' range
#'
#' @description
#' Get an aggregation of service statistics defined by a specific time range.
#'
#' See [https://paws-r.github.io/docs/xray/get_time_series_service_statistics.html](https://paws-r.github.io/docs/xray/get_time_series_service_statistics.html) for full documentation.
#'
#' @param StartTime &#91;required&#93; The start of the time frame for which to aggregate statistics.
#' @param EndTime &#91;required&#93; The end of the time frame for which to aggregate statistics.
#' @param GroupName The case-sensitive name of the group for which to pull statistics from.
#' @param GroupARN The Amazon Resource Name (ARN) of the group for which to pull statistics
#' from.
#' @param EntitySelectorExpression A filter expression defining entities that will be aggregated for
#' statistics. Supports ID, service, and edge functions. If no selector
#' expression is specified, edge statistics are returned.
#' @param Period Aggregation period in seconds.
#' @param ForecastStatistics The forecasted high and low fault count values. Forecast enabled
#' requests require the EntitySelectorExpression ID be provided.
#' @param NextToken Pagination token.
#'
#' @keywords internal
#'
#' @rdname xray_get_time_series_service_statistics
xray_get_time_series_service_statistics <- function(StartTime, EndTime, GroupName = NULL, GroupARN = NULL, EntitySelectorExpression = NULL, Period = NULL, ForecastStatistics = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetTimeSeriesServiceStatistics",
    http_method = "POST",
    http_path = "/TimeSeriesServiceStatistics",
    paginator = list()
  )
  input <- .xray$get_time_series_service_statistics_input(StartTime = StartTime, EndTime = EndTime, GroupName = GroupName, GroupARN = GroupARN, EntitySelectorExpression = EntitySelectorExpression, Period = Period, ForecastStatistics = ForecastStatistics, NextToken = NextToken)
  output <- .xray$get_time_series_service_statistics_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_time_series_service_statistics <- xray_get_time_series_service_statistics

#' Retrieves a service graph for one or more specific trace IDs
#'
#' @description
#' Retrieves a service graph for one or more specific trace IDs.
#'
#' See [https://paws-r.github.io/docs/xray/get_trace_graph.html](https://paws-r.github.io/docs/xray/get_trace_graph.html) for full documentation.
#'
#' @param TraceIds &#91;required&#93; Trace IDs of requests for which to generate a service graph.
#' @param NextToken Pagination token.
#'
#' @keywords internal
#'
#' @rdname xray_get_trace_graph
xray_get_trace_graph <- function(TraceIds, NextToken = NULL) {
  op <- new_operation(
    name = "GetTraceGraph",
    http_method = "POST",
    http_path = "/TraceGraph",
    paginator = list()
  )
  input <- .xray$get_trace_graph_input(TraceIds = TraceIds, NextToken = NextToken)
  output <- .xray$get_trace_graph_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_trace_graph <- xray_get_trace_graph

#' Retrieves IDs and annotations for traces available for a specified time
#' frame using an optional filter
#'
#' @description
#' Retrieves IDs and annotations for traces available for a specified time frame using an optional filter. To get the full traces, pass the trace IDs to [`batch_get_traces`][xray_batch_get_traces].
#'
#' See [https://paws-r.github.io/docs/xray/get_trace_summaries.html](https://paws-r.github.io/docs/xray/get_trace_summaries.html) for full documentation.
#'
#' @param StartTime &#91;required&#93; The start of the time frame for which to retrieve traces.
#' @param EndTime &#91;required&#93; The end of the time frame for which to retrieve traces.
#' @param TimeRangeType A parameter to indicate whether to query trace summaries by TraceId or
#' Event time.
#' @param Sampling Set to `true` to get summaries for only a subset of available traces.
#' @param SamplingStrategy A parameter to indicate whether to enable sampling on trace summaries.
#' Input parameters are Name and Value.
#' @param FilterExpression Specify a filter expression to retrieve trace summaries for services or
#' requests that meet certain requirements.
#' @param NextToken Specify the pagination token returned by a previous request to retrieve
#' the next page of results.
#'
#' @keywords internal
#'
#' @rdname xray_get_trace_summaries
xray_get_trace_summaries <- function(StartTime, EndTime, TimeRangeType = NULL, Sampling = NULL, SamplingStrategy = NULL, FilterExpression = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetTraceSummaries",
    http_method = "POST",
    http_path = "/TraceSummaries",
    paginator = list()
  )
  input <- .xray$get_trace_summaries_input(StartTime = StartTime, EndTime = EndTime, TimeRangeType = TimeRangeType, Sampling = Sampling, SamplingStrategy = SamplingStrategy, FilterExpression = FilterExpression, NextToken = NextToken)
  output <- .xray$get_trace_summaries_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_trace_summaries <- xray_get_trace_summaries

#' Returns a list of tags that are applied to the specified Amazon Web
#' Services X-Ray group or sampling rule
#'
#' @description
#' Returns a list of tags that are applied to the specified Amazon Web Services X-Ray group or sampling rule.
#'
#' See [https://paws-r.github.io/docs/xray/list_tags_for_resource.html](https://paws-r.github.io/docs/xray/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.
#' @param NextToken A pagination token. If multiple pages of results are returned, use the
#' `NextToken` value returned with the current page of results as the value
#' of this parameter to get the next page of results.
#'
#' @keywords internal
#'
#' @rdname xray_list_tags_for_resource
xray_list_tags_for_resource <- function(ResourceARN, NextToken = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/ListTagsForResource",
    paginator = list()
  )
  input <- .xray$list_tags_for_resource_input(ResourceARN = ResourceARN, NextToken = NextToken)
  output <- .xray$list_tags_for_resource_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$list_tags_for_resource <- xray_list_tags_for_resource

#' Updates the encryption configuration for X-Ray data
#'
#' @description
#' Updates the encryption configuration for X-Ray data.
#'
#' See [https://paws-r.github.io/docs/xray/put_encryption_config.html](https://paws-r.github.io/docs/xray/put_encryption_config.html) for full documentation.
#'
#' @param KeyId An Amazon Web Services KMS key in one of the following formats:
#' 
#' -   **Alias** - The name of the key. For example, `alias/MyKey`.
#' 
#' -   **Key ID** - The KMS key ID of the key. For example,
#'     `ae4aa6d49-a4d8-9df9-a475-4ff6d7898456`. Amazon Web Services X-Ray
#'     does not support asymmetric KMS keys.
#' 
#' -   **ARN** - The full Amazon Resource Name of the key ID or alias. For
#'     example,
#'     `arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456`.
#'     Use this format to specify a key in a different account.
#' 
#' Omit this key if you set `Type` to `NONE`.
#' @param Type &#91;required&#93; The type of encryption. Set to `KMS` to use your own key for encryption.
#' Set to `NONE` for default encryption.
#'
#' @keywords internal
#'
#' @rdname xray_put_encryption_config
xray_put_encryption_config <- function(KeyId = NULL, Type) {
  op <- new_operation(
    name = "PutEncryptionConfig",
    http_method = "POST",
    http_path = "/PutEncryptionConfig",
    paginator = list()
  )
  input <- .xray$put_encryption_config_input(KeyId = KeyId, Type = Type)
  output <- .xray$put_encryption_config_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$put_encryption_config <- xray_put_encryption_config

#' Used by the Amazon Web Services X-Ray daemon to upload telemetry
#'
#' @description
#' Used by the Amazon Web Services X-Ray daemon to upload telemetry.
#'
#' See [https://paws-r.github.io/docs/xray/put_telemetry_records.html](https://paws-r.github.io/docs/xray/put_telemetry_records.html) for full documentation.
#'
#' @param TelemetryRecords &#91;required&#93; 
#' @param EC2InstanceId 
#' @param Hostname 
#' @param ResourceARN 
#'
#' @keywords internal
#'
#' @rdname xray_put_telemetry_records
xray_put_telemetry_records <- function(TelemetryRecords, EC2InstanceId = NULL, Hostname = NULL, ResourceARN = NULL) {
  op <- new_operation(
    name = "PutTelemetryRecords",
    http_method = "POST",
    http_path = "/TelemetryRecords",
    paginator = list()
  )
  input <- .xray$put_telemetry_records_input(TelemetryRecords = TelemetryRecords, EC2InstanceId = EC2InstanceId, Hostname = Hostname, ResourceARN = ResourceARN)
  output <- .xray$put_telemetry_records_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$put_telemetry_records <- xray_put_telemetry_records

#' Uploads segment documents to Amazon Web Services X-Ray
#'
#' @description
#' Uploads segment documents to Amazon Web Services X-Ray. The [X-Ray SDK](https://docs.aws.amazon.com/xray/index.html) generates segment documents and sends them to the X-Ray daemon, which uploads them in batches. A segment document can be a completed segment, an in-progress segment, or an array of subsegments.
#'
#' See [https://paws-r.github.io/docs/xray/put_trace_segments.html](https://paws-r.github.io/docs/xray/put_trace_segments.html) for full documentation.
#'
#' @param TraceSegmentDocuments &#91;required&#93; A string containing a JSON document defining one or more segments or
#' subsegments.
#'
#' @keywords internal
#'
#' @rdname xray_put_trace_segments
xray_put_trace_segments <- function(TraceSegmentDocuments) {
  op <- new_operation(
    name = "PutTraceSegments",
    http_method = "POST",
    http_path = "/TraceSegments",
    paginator = list()
  )
  input <- .xray$put_trace_segments_input(TraceSegmentDocuments = TraceSegmentDocuments)
  output <- .xray$put_trace_segments_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$put_trace_segments <- xray_put_trace_segments

#' Applies tags to an existing Amazon Web Services X-Ray group or sampling
#' rule
#'
#' @description
#' Applies tags to an existing Amazon Web Services X-Ray group or sampling rule.
#'
#' See [https://paws-r.github.io/docs/xray/tag_resource.html](https://paws-r.github.io/docs/xray/tag_resource.html) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.
#' @param Tags &#91;required&#93; A map that contains one or more tag keys and tag values to attach to an
#' X-Ray group or sampling rule. For more information about ways to use
#' tags, see [Tagging Amazon Web Services
#' resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
#' in the *Amazon Web Services General Reference*.
#' 
#' The following restrictions apply to tags:
#' 
#' -   Maximum number of user-applied tags per resource: 50
#' 
#' -   Maximum tag key length: 128 Unicode characters
#' 
#' -   Maximum tag value length: 256 Unicode characters
#' 
#' -   Valid values for key and value: a-z, A-Z, 0-9, space, and the
#'     following characters: _ . : / = + - and @@
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Don't use `aws:` as a prefix for keys; it's reserved for Amazon Web
#'     Services use. You cannot edit or delete system tags.
#'
#' @keywords internal
#'
#' @rdname xray_tag_resource
xray_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/TagResource",
    paginator = list()
  )
  input <- .xray$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .xray$tag_resource_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$tag_resource <- xray_tag_resource

#' Removes tags from an Amazon Web Services X-Ray group or sampling rule
#'
#' @description
#' Removes tags from an Amazon Web Services X-Ray group or sampling rule. You cannot edit or delete system tags (those with an `aws:` prefix).
#'
#' See [https://paws-r.github.io/docs/xray/untag_resource.html](https://paws-r.github.io/docs/xray/untag_resource.html) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.
#' @param TagKeys &#91;required&#93; Keys for one or more tags that you want to remove from an X-Ray group or
#' sampling rule.
#'
#' @keywords internal
#'
#' @rdname xray_untag_resource
xray_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/UntagResource",
    paginator = list()
  )
  input <- .xray$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .xray$untag_resource_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$untag_resource <- xray_untag_resource

#' Updates a group resource
#'
#' @description
#' Updates a group resource.
#'
#' See [https://paws-r.github.io/docs/xray/update_group.html](https://paws-r.github.io/docs/xray/update_group.html) for full documentation.
#'
#' @param GroupName The case-sensitive name of the group.
#' @param GroupARN The ARN that was generated upon creation.
#' @param FilterExpression The updated filter expression defining criteria by which to group
#' traces.
#' @param InsightsConfiguration The structure containing configurations related to insights.
#' 
#' -   The InsightsEnabled boolean can be set to true to enable insights
#'     for the group or false to disable insights for the group.
#' 
#' -   The NotifcationsEnabled boolean can be set to true to enable
#'     insights notifications for the group. Notifications can only be
#'     enabled on a group with InsightsEnabled set to true.
#'
#' @keywords internal
#'
#' @rdname xray_update_group
xray_update_group <- function(GroupName = NULL, GroupARN = NULL, FilterExpression = NULL, InsightsConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateGroup",
    http_method = "POST",
    http_path = "/UpdateGroup",
    paginator = list()
  )
  input <- .xray$update_group_input(GroupName = GroupName, GroupARN = GroupARN, FilterExpression = FilterExpression, InsightsConfiguration = InsightsConfiguration)
  output <- .xray$update_group_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$update_group <- xray_update_group

#' Modifies a sampling rule's configuration
#'
#' @description
#' Modifies a sampling rule's configuration.
#'
#' See [https://paws-r.github.io/docs/xray/update_sampling_rule.html](https://paws-r.github.io/docs/xray/update_sampling_rule.html) for full documentation.
#'
#' @param SamplingRuleUpdate &#91;required&#93; The rule and fields to change.
#'
#' @keywords internal
#'
#' @rdname xray_update_sampling_rule
xray_update_sampling_rule <- function(SamplingRuleUpdate) {
  op <- new_operation(
    name = "UpdateSamplingRule",
    http_method = "POST",
    http_path = "/UpdateSamplingRule",
    paginator = list()
  )
  input <- .xray$update_sampling_rule_input(SamplingRuleUpdate = SamplingRuleUpdate)
  output <- .xray$update_sampling_rule_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$update_sampling_rule <- xray_update_sampling_rule
