% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codestar_operations.R
\name{codestar_update_user_profile}
\alias{codestar_update_user_profile}
\title{Updates a user's profile in AWS CodeStar}
\usage{
codestar_update_user_profile(
  userArn,
  displayName = NULL,
  emailAddress = NULL,
  sshPublicKey = NULL
)
}
\arguments{
\item{userArn}{[required] The name that will be displayed as the friendly name for the user in AWS
CodeStar.}

\item{displayName}{The name that is displayed as the friendly name for the user in AWS
CodeStar.}

\item{emailAddress}{The email address that is displayed as part of the user's profile in AWS
CodeStar.}

\item{sshPublicKey}{The SSH public key associated with the user in AWS CodeStar. If a
project owner allows the user remote access to project resources, this
public key will be used along with the user's private key for SSH
access.}
}
\description{
Updates a user's profile in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar.

See \url{https://paws-r.github.io/docs/codestar/update_user_profile.html} for full documentation.
}
\keyword{internal}
