% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devopsguru_operations.R
\name{devopsguru_describe_resource_collection_health}
\alias{devopsguru_describe_resource_collection_health}
\title{Returns the number of open proactive insights, open reactive insights,
and the Mean Time to Recover (MTTR) for all closed insights in resource
collections in your account}
\usage{
devopsguru_describe_resource_collection_health(
  ResourceCollectionType,
  NextToken = NULL
)
}
\arguments{
\item{ResourceCollectionType}{[required] An Amazon Web Services resource collection type. This type specifies how
analyzed Amazon Web Services resources are defined. The two types of
Amazon Web Services resource collections supported are Amazon Web
Services CloudFormation stacks and Amazon Web Services resources that
contain the same Amazon Web Services tag. DevOps Guru can be configured
to analyze the Amazon Web Services resources that are defined in the
stacks or that are tagged using the same tag \emph{key}. You can specify up
to 500 Amazon Web Services CloudFormation stacks.}

\item{NextToken}{The pagination token to use to retrieve the next page of results for
this operation. If this value is null, it retrieves the first page.}
}
\description{
Returns the number of open proactive insights, open reactive insights, and the Mean Time to Recover (MTTR) for all closed insights in resource collections in your account. You specify the type of Amazon Web Services resources collection. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag \emph{key}. You can specify up to 500 Amazon Web Services CloudFormation stacks.

See \url{https://paws-r.github.io/docs/devopsguru/describe_resource_collection_health.html} for full documentation.
}
\keyword{internal}
