% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codepipeline_operations.R
\name{codepipeline_put_webhook}
\alias{codepipeline_put_webhook}
\title{Defines a webhook and returns a unique webhook URL generated by
CodePipeline}
\usage{
codepipeline_put_webhook(webhook, tags = NULL)
}
\arguments{
\item{webhook}{[required] The detail provided in an input file to create the webhook, such as the
webhook name, the pipeline name, and the action name. Give the webhook a
unique name that helps you identify it. You might name the webhook after
the pipeline and action it targets so that you can easily recognize what
it's used for later.}

\item{tags}{The tags for the webhook.}
}
\description{
Defines a webhook and returns a unique webhook URL generated by CodePipeline. This URL can be supplied to third party source hosting providers to call every time there's a code change. When CodePipeline receives a POST request on this URL, the pipeline defined in the webhook is started as long as the POST request satisfied the authentication and filtering requirements supplied when defining the webhook. RegisterWebhookWithThirdParty and DeregisterWebhookWithThirdParty APIs can be used to automatically configure supported third parties to call the generated webhook URL.

See \url{https://www.paws-r-sdk.com/docs/codepipeline_put_webhook/} for full documentation.
}
\keyword{internal}
