% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_service.R
\name{codebuild}
\alias{codebuild}
\title{AWS CodeBuild}
\usage{
codebuild(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
CodeBuild

CodeBuild is a fully managed build service in the cloud. CodeBuild
compiles your source code, runs unit tests, and produces artifacts that
are ready to deploy. CodeBuild eliminates the need to provision, manage,
and scale your own build servers. It provides prepackaged build
environments for the most popular programming languages and build tools,
such as Apache Maven, Gradle, and more. You can also fully customize
build environments in CodeBuild to use your own build tools. CodeBuild
scales automatically to meet peak build requests. You pay only for the
build time you consume. For more information about CodeBuild, see the
\emph{\href{https://docs.aws.amazon.com/codebuild/latest/userguide/welcome.html}{CodeBuild User Guide}.}
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- codebuild(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=codebuild_batch_delete_builds]{batch_delete_builds} \tab Deletes one or more builds\cr
\link[=codebuild_batch_get_build_batches]{batch_get_build_batches} \tab Retrieves information about one or more batch builds\cr
\link[=codebuild_batch_get_builds]{batch_get_builds} \tab Gets information about one or more builds\cr
\link[=codebuild_batch_get_fleets]{batch_get_fleets} \tab Gets information about one or more compute fleets\cr
\link[=codebuild_batch_get_projects]{batch_get_projects} \tab Gets information about one or more build projects\cr
\link[=codebuild_batch_get_report_groups]{batch_get_report_groups} \tab Returns an array of report groups\cr
\link[=codebuild_batch_get_reports]{batch_get_reports} \tab Returns an array of reports\cr
\link[=codebuild_create_fleet]{create_fleet} \tab Creates a compute fleet\cr
\link[=codebuild_create_project]{create_project} \tab Creates a build project\cr
\link[=codebuild_create_report_group]{create_report_group} \tab Creates a report group\cr
\link[=codebuild_create_webhook]{create_webhook} \tab For an existing CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository, enables CodeBuild to start rebuilding the source code every time a code change is pushed to the repository\cr
\link[=codebuild_delete_build_batch]{delete_build_batch} \tab Deletes a batch build\cr
\link[=codebuild_delete_fleet]{delete_fleet} \tab Deletes a compute fleet\cr
\link[=codebuild_delete_project]{delete_project} \tab Deletes a build project\cr
\link[=codebuild_delete_report]{delete_report} \tab Deletes a report\cr
\link[=codebuild_delete_report_group]{delete_report_group} \tab Deletes a report group\cr
\link[=codebuild_delete_resource_policy]{delete_resource_policy} \tab Deletes a resource policy that is identified by its resource ARN\cr
\link[=codebuild_delete_source_credentials]{delete_source_credentials} \tab Deletes a set of GitHub, GitHub Enterprise, or Bitbucket source credentials\cr
\link[=codebuild_delete_webhook]{delete_webhook} \tab For an existing CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository, stops CodeBuild from rebuilding the source code every time a code change is pushed to the repository\cr
\link[=codebuild_describe_code_coverages]{describe_code_coverages} \tab Retrieves one or more code coverage reports\cr
\link[=codebuild_describe_test_cases]{describe_test_cases} \tab Returns a list of details about test cases for a report\cr
\link[=codebuild_get_report_group_trend]{get_report_group_trend} \tab Analyzes and accumulates test report values for the specified test reports\cr
\link[=codebuild_get_resource_policy]{get_resource_policy} \tab Gets a resource policy that is identified by its resource ARN\cr
\link[=codebuild_import_source_credentials]{import_source_credentials} \tab Imports the source repository credentials for an CodeBuild project that has its source code stored in a GitHub, GitHub Enterprise, or Bitbucket repository\cr
\link[=codebuild_invalidate_project_cache]{invalidate_project_cache} \tab Resets the cache for a project\cr
\link[=codebuild_list_build_batches]{list_build_batches} \tab Retrieves the identifiers of your build batches in the current region\cr
\link[=codebuild_list_build_batches_for_project]{list_build_batches_for_project} \tab Retrieves the identifiers of the build batches for a specific project\cr
\link[=codebuild_list_builds]{list_builds} \tab Gets a list of build IDs, with each build ID representing a single build\cr
\link[=codebuild_list_builds_for_project]{list_builds_for_project} \tab Gets a list of build identifiers for the specified build project, with each build identifier representing a single build\cr
\link[=codebuild_list_curated_environment_images]{list_curated_environment_images} \tab Gets information about Docker images that are managed by CodeBuild\cr
\link[=codebuild_list_fleets]{list_fleets} \tab Gets a list of compute fleet names with each compute fleet name representing a single compute fleet\cr
\link[=codebuild_list_projects]{list_projects} \tab Gets a list of build project names, with each build project name representing a single build project\cr
\link[=codebuild_list_report_groups]{list_report_groups} \tab Gets a list ARNs for the report groups in the current Amazon Web Services account\cr
\link[=codebuild_list_reports]{list_reports} \tab Returns a list of ARNs for the reports in the current Amazon Web Services account\cr
\link[=codebuild_list_reports_for_report_group]{list_reports_for_report_group} \tab Returns a list of ARNs for the reports that belong to a ReportGroup\cr
\link[=codebuild_list_shared_projects]{list_shared_projects} \tab Gets a list of projects that are shared with other Amazon Web Services accounts or users\cr
\link[=codebuild_list_shared_report_groups]{list_shared_report_groups} \tab Gets a list of report groups that are shared with other Amazon Web Services accounts or users\cr
\link[=codebuild_list_source_credentials]{list_source_credentials} \tab Returns a list of SourceCredentialsInfo objects\cr
\link[=codebuild_put_resource_policy]{put_resource_policy} \tab Stores a resource policy for the ARN of a Project or ReportGroup object\cr
\link[=codebuild_retry_build]{retry_build} \tab Restarts a build\cr
\link[=codebuild_retry_build_batch]{retry_build_batch} \tab Restarts a failed batch build\cr
\link[=codebuild_start_build]{start_build} \tab Starts running a build with the settings defined in the project\cr
\link[=codebuild_start_build_batch]{start_build_batch} \tab Starts a batch build for a project\cr
\link[=codebuild_stop_build]{stop_build} \tab Attempts to stop running a build\cr
\link[=codebuild_stop_build_batch]{stop_build_batch} \tab Stops a running batch build\cr
\link[=codebuild_update_fleet]{update_fleet} \tab Updates a compute fleet\cr
\link[=codebuild_update_project]{update_project} \tab Changes the settings of a build project\cr
\link[=codebuild_update_project_visibility]{update_project_visibility} \tab Changes the public visibility for a project\cr
\link[=codebuild_update_report_group]{update_report_group} \tab Updates a report group\cr
\link[=codebuild_update_webhook]{update_webhook} \tab Updates the webhook associated with an CodeBuild build project
}
}

\examples{
\dontrun{
svc <- codebuild()
svc$batch_delete_builds(
  Foo = 123
)
}

}
