# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include nimblestudio_service.R
NULL

#' Accept EULAs
#'
#' @description
#' Accept EULAs.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/accept_eulas.html](https://paws-r.github.io/docs/nimblestudio/accept_eulas.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param eulaIds The EULA ID.
#' @param studioId &#91;required&#93; A collection of EULA IDs.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_accept_eulas
nimblestudio_accept_eulas <- function(clientToken = NULL, eulaIds = NULL, studioId) {
  op <- new_operation(
    name = "AcceptEulas",
    http_method = "POST",
    http_path = "/2020-08-01/studios/{studioId}/eula-acceptances",
    paginator = list()
  )
  input <- .nimblestudio$accept_eulas_input(clientToken = clientToken, eulaIds = eulaIds, studioId = studioId)
  output <- .nimblestudio$accept_eulas_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$accept_eulas <- nimblestudio_accept_eulas

#' Create a launch profile
#'
#' @description
#' Create a launch profile.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/create_launch_profile.html](https://paws-r.github.io/docs/nimblestudio/create_launch_profile.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param description The description.
#' @param ec2SubnetIds &#91;required&#93; Specifies the IDs of the EC2 subnets where streaming sessions will be
#' accessible from. These subnets must support the specified instance
#' types.
#' @param launchProfileProtocolVersions &#91;required&#93; The version number of the protocol that is used by the launch profile.
#' The only valid version is "2021-03-31".
#' @param name &#91;required&#93; The name for the launch profile.
#' @param streamConfiguration &#91;required&#93; A configuration for a streaming session.
#' @param studioComponentIds &#91;required&#93; Unique identifiers for a collection of studio components that can be
#' used with this launch profile.
#' @param studioId &#91;required&#93; The studio ID.
#' @param tags A collection of labels, in the form of key:value pairs, that apply to
#' this resource.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_create_launch_profile
nimblestudio_create_launch_profile <- function(clientToken = NULL, description = NULL, ec2SubnetIds, launchProfileProtocolVersions, name, streamConfiguration, studioComponentIds, studioId, tags = NULL) {
  op <- new_operation(
    name = "CreateLaunchProfile",
    http_method = "POST",
    http_path = "/2020-08-01/studios/{studioId}/launch-profiles",
    paginator = list()
  )
  input <- .nimblestudio$create_launch_profile_input(clientToken = clientToken, description = description, ec2SubnetIds = ec2SubnetIds, launchProfileProtocolVersions = launchProfileProtocolVersions, name = name, streamConfiguration = streamConfiguration, studioComponentIds = studioComponentIds, studioId = studioId, tags = tags)
  output <- .nimblestudio$create_launch_profile_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$create_launch_profile <- nimblestudio_create_launch_profile

#' Creates a streaming image resource in a studio
#'
#' @description
#' Creates a streaming image resource in a studio.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/create_streaming_image.html](https://paws-r.github.io/docs/nimblestudio/create_streaming_image.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param description A human-readable description of the streaming image.
#' @param ec2ImageId &#91;required&#93; The ID of an EC2 machine image with which to create this streaming
#' image.
#' @param name &#91;required&#93; A friendly name for a streaming image resource.
#' @param studioId &#91;required&#93; The studio ID.
#' @param tags A collection of labels, in the form of key:value pairs, that apply to
#' this resource.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_create_streaming_image
nimblestudio_create_streaming_image <- function(clientToken = NULL, description = NULL, ec2ImageId, name, studioId, tags = NULL) {
  op <- new_operation(
    name = "CreateStreamingImage",
    http_method = "POST",
    http_path = "/2020-08-01/studios/{studioId}/streaming-images",
    paginator = list()
  )
  input <- .nimblestudio$create_streaming_image_input(clientToken = clientToken, description = description, ec2ImageId = ec2ImageId, name = name, studioId = studioId, tags = tags)
  output <- .nimblestudio$create_streaming_image_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$create_streaming_image <- nimblestudio_create_streaming_image

#' Creates a streaming session in a studio
#'
#' @description
#' Creates a streaming session in a studio.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/create_streaming_session.html](https://paws-r.github.io/docs/nimblestudio/create_streaming_session.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param ec2InstanceType The EC2 Instance type used for the streaming session.
#' @param launchProfileId The launch profile ID.
#' @param ownedBy The user ID of the user that owns the streaming session. The user that
#' owns the session will be logging into the session and interacting with
#' the virtual workstation.
#' @param streamingImageId The ID of the streaming image.
#' @param studioId &#91;required&#93; The studio ID.
#' @param tags A collection of labels, in the form of key:value pairs, that apply to
#' this resource.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_create_streaming_session
nimblestudio_create_streaming_session <- function(clientToken = NULL, ec2InstanceType = NULL, launchProfileId = NULL, ownedBy = NULL, streamingImageId = NULL, studioId, tags = NULL) {
  op <- new_operation(
    name = "CreateStreamingSession",
    http_method = "POST",
    http_path = "/2020-08-01/studios/{studioId}/streaming-sessions",
    paginator = list()
  )
  input <- .nimblestudio$create_streaming_session_input(clientToken = clientToken, ec2InstanceType = ec2InstanceType, launchProfileId = launchProfileId, ownedBy = ownedBy, streamingImageId = streamingImageId, studioId = studioId, tags = tags)
  output <- .nimblestudio$create_streaming_session_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$create_streaming_session <- nimblestudio_create_streaming_session

#' Creates a streaming session stream for a streaming session
#'
#' @description
#' Creates a streaming session stream for a streaming session.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/create_streaming_session_stream.html](https://paws-r.github.io/docs/nimblestudio/create_streaming_session_stream.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param expirationInSeconds The expiration time in seconds.
#' @param sessionId &#91;required&#93; The streaming session ID.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_create_streaming_session_stream
nimblestudio_create_streaming_session_stream <- function(clientToken = NULL, expirationInSeconds = NULL, sessionId, studioId) {
  op <- new_operation(
    name = "CreateStreamingSessionStream",
    http_method = "POST",
    http_path = "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}/streams",
    paginator = list()
  )
  input <- .nimblestudio$create_streaming_session_stream_input(clientToken = clientToken, expirationInSeconds = expirationInSeconds, sessionId = sessionId, studioId = studioId)
  output <- .nimblestudio$create_streaming_session_stream_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$create_streaming_session_stream <- nimblestudio_create_streaming_session_stream

#' Create a new Studio
#'
#' @description
#' Create a new Studio.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/create_studio.html](https://paws-r.github.io/docs/nimblestudio/create_studio.html) for full documentation.
#'
#' @param adminRoleArn &#91;required&#93; The IAM role that Studio Admins will assume when logging in to the
#' Nimble Studio portal.
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param displayName &#91;required&#93; A friendly name for the studio.
#' @param studioEncryptionConfiguration The studio encryption configuration.
#' @param studioName &#91;required&#93; The studio name that is used in the URL of the Nimble Studio portal when
#' accessed by Nimble Studio users.
#' @param tags A collection of labels, in the form of key:value pairs, that apply to
#' this resource.
#' @param userRoleArn &#91;required&#93; The IAM role that Studio Users will assume when logging in to the Nimble
#' Studio portal.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_create_studio
nimblestudio_create_studio <- function(adminRoleArn, clientToken = NULL, displayName, studioEncryptionConfiguration = NULL, studioName, tags = NULL, userRoleArn) {
  op <- new_operation(
    name = "CreateStudio",
    http_method = "POST",
    http_path = "/2020-08-01/studios",
    paginator = list()
  )
  input <- .nimblestudio$create_studio_input(adminRoleArn = adminRoleArn, clientToken = clientToken, displayName = displayName, studioEncryptionConfiguration = studioEncryptionConfiguration, studioName = studioName, tags = tags, userRoleArn = userRoleArn)
  output <- .nimblestudio$create_studio_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$create_studio <- nimblestudio_create_studio

#' Creates a studio component resource
#'
#' @description
#' Creates a studio component resource.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/create_studio_component.html](https://paws-r.github.io/docs/nimblestudio/create_studio_component.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param configuration The configuration of the studio component, based on component type.
#' @param description The description.
#' @param ec2SecurityGroupIds The EC2 security groups that control access to the studio component.
#' @param initializationScripts Initialization scripts for studio components.
#' @param name &#91;required&#93; The name for the studio component.
#' @param runtimeRoleArn An IAM role attached to a Studio Component that gives the studio
#' component access to AWS resources at anytime while the instance is
#' running.
#' @param scriptParameters Parameters for the studio component scripts.
#' @param secureInitializationRoleArn An IAM role attached to Studio Component when the system initialization
#' script runs which give the studio component access to AWS resources when
#' the system initialization script runs.
#' @param studioId &#91;required&#93; The studio ID.
#' @param subtype The specific subtype of a studio component.
#' @param tags A collection of labels, in the form of key:value pairs, that apply to
#' this resource.
#' @param type &#91;required&#93; The type of the studio component.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_create_studio_component
nimblestudio_create_studio_component <- function(clientToken = NULL, configuration = NULL, description = NULL, ec2SecurityGroupIds = NULL, initializationScripts = NULL, name, runtimeRoleArn = NULL, scriptParameters = NULL, secureInitializationRoleArn = NULL, studioId, subtype = NULL, tags = NULL, type) {
  op <- new_operation(
    name = "CreateStudioComponent",
    http_method = "POST",
    http_path = "/2020-08-01/studios/{studioId}/studio-components",
    paginator = list()
  )
  input <- .nimblestudio$create_studio_component_input(clientToken = clientToken, configuration = configuration, description = description, ec2SecurityGroupIds = ec2SecurityGroupIds, initializationScripts = initializationScripts, name = name, runtimeRoleArn = runtimeRoleArn, scriptParameters = scriptParameters, secureInitializationRoleArn = secureInitializationRoleArn, studioId = studioId, subtype = subtype, tags = tags, type = type)
  output <- .nimblestudio$create_studio_component_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$create_studio_component <- nimblestudio_create_studio_component

#' Permanently delete a launch profile
#'
#' @description
#' Permanently delete a launch profile.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/delete_launch_profile.html](https://paws-r.github.io/docs/nimblestudio/delete_launch_profile.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param launchProfileId &#91;required&#93; The Launch Profile ID.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_delete_launch_profile
nimblestudio_delete_launch_profile <- function(clientToken = NULL, launchProfileId, studioId) {
  op <- new_operation(
    name = "DeleteLaunchProfile",
    http_method = "DELETE",
    http_path = "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}",
    paginator = list()
  )
  input <- .nimblestudio$delete_launch_profile_input(clientToken = clientToken, launchProfileId = launchProfileId, studioId = studioId)
  output <- .nimblestudio$delete_launch_profile_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$delete_launch_profile <- nimblestudio_delete_launch_profile

#' Delete a user from launch profile membership
#'
#' @description
#' Delete a user from launch profile membership.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/delete_launch_profile_member.html](https://paws-r.github.io/docs/nimblestudio/delete_launch_profile_member.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param launchProfileId &#91;required&#93; The Launch Profile ID.
#' @param principalId &#91;required&#93; The principal ID. This currently supports a Amazon Web Services SSO
#' UserId.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_delete_launch_profile_member
nimblestudio_delete_launch_profile_member <- function(clientToken = NULL, launchProfileId, principalId, studioId) {
  op <- new_operation(
    name = "DeleteLaunchProfileMember",
    http_method = "DELETE",
    http_path = "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership/{principalId}",
    paginator = list()
  )
  input <- .nimblestudio$delete_launch_profile_member_input(clientToken = clientToken, launchProfileId = launchProfileId, principalId = principalId, studioId = studioId)
  output <- .nimblestudio$delete_launch_profile_member_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$delete_launch_profile_member <- nimblestudio_delete_launch_profile_member

#' Delete streaming image
#'
#' @description
#' Delete streaming image.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/delete_streaming_image.html](https://paws-r.github.io/docs/nimblestudio/delete_streaming_image.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param streamingImageId &#91;required&#93; The streaming image ID.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_delete_streaming_image
nimblestudio_delete_streaming_image <- function(clientToken = NULL, streamingImageId, studioId) {
  op <- new_operation(
    name = "DeleteStreamingImage",
    http_method = "DELETE",
    http_path = "/2020-08-01/studios/{studioId}/streaming-images/{streamingImageId}",
    paginator = list()
  )
  input <- .nimblestudio$delete_streaming_image_input(clientToken = clientToken, streamingImageId = streamingImageId, studioId = studioId)
  output <- .nimblestudio$delete_streaming_image_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$delete_streaming_image <- nimblestudio_delete_streaming_image

#' Deletes streaming session resource
#'
#' @description
#' Deletes streaming session resource.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/delete_streaming_session.html](https://paws-r.github.io/docs/nimblestudio/delete_streaming_session.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param sessionId &#91;required&#93; The streaming session ID.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_delete_streaming_session
nimblestudio_delete_streaming_session <- function(clientToken = NULL, sessionId, studioId) {
  op <- new_operation(
    name = "DeleteStreamingSession",
    http_method = "DELETE",
    http_path = "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}",
    paginator = list()
  )
  input <- .nimblestudio$delete_streaming_session_input(clientToken = clientToken, sessionId = sessionId, studioId = studioId)
  output <- .nimblestudio$delete_streaming_session_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$delete_streaming_session <- nimblestudio_delete_streaming_session

#' Delete a studio resource
#'
#' @description
#' Delete a studio resource.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/delete_studio.html](https://paws-r.github.io/docs/nimblestudio/delete_studio.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_delete_studio
nimblestudio_delete_studio <- function(clientToken = NULL, studioId) {
  op <- new_operation(
    name = "DeleteStudio",
    http_method = "DELETE",
    http_path = "/2020-08-01/studios/{studioId}",
    paginator = list()
  )
  input <- .nimblestudio$delete_studio_input(clientToken = clientToken, studioId = studioId)
  output <- .nimblestudio$delete_studio_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$delete_studio <- nimblestudio_delete_studio

#' Deletes a studio component resource
#'
#' @description
#' Deletes a studio component resource.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/delete_studio_component.html](https://paws-r.github.io/docs/nimblestudio/delete_studio_component.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param studioComponentId &#91;required&#93; The studio component ID.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_delete_studio_component
nimblestudio_delete_studio_component <- function(clientToken = NULL, studioComponentId, studioId) {
  op <- new_operation(
    name = "DeleteStudioComponent",
    http_method = "DELETE",
    http_path = "/2020-08-01/studios/{studioId}/studio-components/{studioComponentId}",
    paginator = list()
  )
  input <- .nimblestudio$delete_studio_component_input(clientToken = clientToken, studioComponentId = studioComponentId, studioId = studioId)
  output <- .nimblestudio$delete_studio_component_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$delete_studio_component <- nimblestudio_delete_studio_component

#' Delete a user from studio membership
#'
#' @description
#' Delete a user from studio membership.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/delete_studio_member.html](https://paws-r.github.io/docs/nimblestudio/delete_studio_member.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param principalId &#91;required&#93; The principal ID. This currently supports a Amazon Web Services SSO
#' UserId.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_delete_studio_member
nimblestudio_delete_studio_member <- function(clientToken = NULL, principalId, studioId) {
  op <- new_operation(
    name = "DeleteStudioMember",
    http_method = "DELETE",
    http_path = "/2020-08-01/studios/{studioId}/membership/{principalId}",
    paginator = list()
  )
  input <- .nimblestudio$delete_studio_member_input(clientToken = clientToken, principalId = principalId, studioId = studioId)
  output <- .nimblestudio$delete_studio_member_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$delete_studio_member <- nimblestudio_delete_studio_member

#' Get Eula
#'
#' @description
#' Get Eula.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/get_eula.html](https://paws-r.github.io/docs/nimblestudio/get_eula.html) for full documentation.
#'
#' @param eulaId &#91;required&#93; The EULA ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_get_eula
nimblestudio_get_eula <- function(eulaId) {
  op <- new_operation(
    name = "GetEula",
    http_method = "GET",
    http_path = "/2020-08-01/eulas/{eulaId}",
    paginator = list()
  )
  input <- .nimblestudio$get_eula_input(eulaId = eulaId)
  output <- .nimblestudio$get_eula_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$get_eula <- nimblestudio_get_eula

#' Get a launch profile
#'
#' @description
#' Get a launch profile.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/get_launch_profile.html](https://paws-r.github.io/docs/nimblestudio/get_launch_profile.html) for full documentation.
#'
#' @param launchProfileId &#91;required&#93; The Launch Profile ID.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_get_launch_profile
nimblestudio_get_launch_profile <- function(launchProfileId, studioId) {
  op <- new_operation(
    name = "GetLaunchProfile",
    http_method = "GET",
    http_path = "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}",
    paginator = list()
  )
  input <- .nimblestudio$get_launch_profile_input(launchProfileId = launchProfileId, studioId = studioId)
  output <- .nimblestudio$get_launch_profile_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$get_launch_profile <- nimblestudio_get_launch_profile

#' Launch profile details include the launch profile resource and summary
#' information of resources that are used by, or available to, the launch
#' profile
#'
#' @description
#' Launch profile details include the launch profile resource and summary information of resources that are used by, or available to, the launch profile. This includes the name and description of all studio components used by the launch profiles, and the name and description of streaming images that can be used with this launch profile.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/get_launch_profile_details.html](https://paws-r.github.io/docs/nimblestudio/get_launch_profile_details.html) for full documentation.
#'
#' @param launchProfileId &#91;required&#93; The Launch Profile ID.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_get_launch_profile_details
nimblestudio_get_launch_profile_details <- function(launchProfileId, studioId) {
  op <- new_operation(
    name = "GetLaunchProfileDetails",
    http_method = "GET",
    http_path = "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/details",
    paginator = list()
  )
  input <- .nimblestudio$get_launch_profile_details_input(launchProfileId = launchProfileId, studioId = studioId)
  output <- .nimblestudio$get_launch_profile_details_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$get_launch_profile_details <- nimblestudio_get_launch_profile_details

#' Get a launch profile initialization
#'
#' @description
#' Get a launch profile initialization.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/get_launch_profile_initialization.html](https://paws-r.github.io/docs/nimblestudio/get_launch_profile_initialization.html) for full documentation.
#'
#' @param launchProfileId &#91;required&#93; The Launch Profile ID.
#' @param launchProfileProtocolVersions &#91;required&#93; The launch profile protocol versions supported by the client.
#' @param launchPurpose &#91;required&#93; The launch purpose.
#' @param platform &#91;required&#93; The platform where this Launch Profile will be used, either WINDOWS or
#' LINUX.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_get_launch_profile_initialization
nimblestudio_get_launch_profile_initialization <- function(launchProfileId, launchProfileProtocolVersions, launchPurpose, platform, studioId) {
  op <- new_operation(
    name = "GetLaunchProfileInitialization",
    http_method = "GET",
    http_path = "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/init",
    paginator = list()
  )
  input <- .nimblestudio$get_launch_profile_initialization_input(launchProfileId = launchProfileId, launchProfileProtocolVersions = launchProfileProtocolVersions, launchPurpose = launchPurpose, platform = platform, studioId = studioId)
  output <- .nimblestudio$get_launch_profile_initialization_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$get_launch_profile_initialization <- nimblestudio_get_launch_profile_initialization

#' Get a user persona in launch profile membership
#'
#' @description
#' Get a user persona in launch profile membership.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/get_launch_profile_member.html](https://paws-r.github.io/docs/nimblestudio/get_launch_profile_member.html) for full documentation.
#'
#' @param launchProfileId &#91;required&#93; The Launch Profile ID.
#' @param principalId &#91;required&#93; The principal ID. This currently supports a Amazon Web Services SSO
#' UserId.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_get_launch_profile_member
nimblestudio_get_launch_profile_member <- function(launchProfileId, principalId, studioId) {
  op <- new_operation(
    name = "GetLaunchProfileMember",
    http_method = "GET",
    http_path = "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership/{principalId}",
    paginator = list()
  )
  input <- .nimblestudio$get_launch_profile_member_input(launchProfileId = launchProfileId, principalId = principalId, studioId = studioId)
  output <- .nimblestudio$get_launch_profile_member_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$get_launch_profile_member <- nimblestudio_get_launch_profile_member

#' Get streaming image
#'
#' @description
#' Get streaming image.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/get_streaming_image.html](https://paws-r.github.io/docs/nimblestudio/get_streaming_image.html) for full documentation.
#'
#' @param streamingImageId &#91;required&#93; The streaming image ID.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_get_streaming_image
nimblestudio_get_streaming_image <- function(streamingImageId, studioId) {
  op <- new_operation(
    name = "GetStreamingImage",
    http_method = "GET",
    http_path = "/2020-08-01/studios/{studioId}/streaming-images/{streamingImageId}",
    paginator = list()
  )
  input <- .nimblestudio$get_streaming_image_input(streamingImageId = streamingImageId, studioId = studioId)
  output <- .nimblestudio$get_streaming_image_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$get_streaming_image <- nimblestudio_get_streaming_image

#' Gets StreamingSession resource
#'
#' @description
#' Gets StreamingSession resource.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/get_streaming_session.html](https://paws-r.github.io/docs/nimblestudio/get_streaming_session.html) for full documentation.
#'
#' @param sessionId &#91;required&#93; The streaming session ID.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_get_streaming_session
nimblestudio_get_streaming_session <- function(sessionId, studioId) {
  op <- new_operation(
    name = "GetStreamingSession",
    http_method = "GET",
    http_path = "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}",
    paginator = list()
  )
  input <- .nimblestudio$get_streaming_session_input(sessionId = sessionId, studioId = studioId)
  output <- .nimblestudio$get_streaming_session_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$get_streaming_session <- nimblestudio_get_streaming_session

#' Gets a StreamingSessionStream for a streaming session
#'
#' @description
#' Gets a StreamingSessionStream for a streaming session.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/get_streaming_session_stream.html](https://paws-r.github.io/docs/nimblestudio/get_streaming_session_stream.html) for full documentation.
#'
#' @param sessionId &#91;required&#93; The streaming session ID.
#' @param streamId &#91;required&#93; The streaming session stream ID.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_get_streaming_session_stream
nimblestudio_get_streaming_session_stream <- function(sessionId, streamId, studioId) {
  op <- new_operation(
    name = "GetStreamingSessionStream",
    http_method = "GET",
    http_path = "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}/streams/{streamId}",
    paginator = list()
  )
  input <- .nimblestudio$get_streaming_session_stream_input(sessionId = sessionId, streamId = streamId, studioId = studioId)
  output <- .nimblestudio$get_streaming_session_stream_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$get_streaming_session_stream <- nimblestudio_get_streaming_session_stream

#' Get a Studio resource
#'
#' @description
#' Get a Studio resource.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/get_studio.html](https://paws-r.github.io/docs/nimblestudio/get_studio.html) for full documentation.
#'
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_get_studio
nimblestudio_get_studio <- function(studioId) {
  op <- new_operation(
    name = "GetStudio",
    http_method = "GET",
    http_path = "/2020-08-01/studios/{studioId}",
    paginator = list()
  )
  input <- .nimblestudio$get_studio_input(studioId = studioId)
  output <- .nimblestudio$get_studio_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$get_studio <- nimblestudio_get_studio

#' Gets a studio component resource
#'
#' @description
#' Gets a studio component resource.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/get_studio_component.html](https://paws-r.github.io/docs/nimblestudio/get_studio_component.html) for full documentation.
#'
#' @param studioComponentId &#91;required&#93; The studio component ID.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_get_studio_component
nimblestudio_get_studio_component <- function(studioComponentId, studioId) {
  op <- new_operation(
    name = "GetStudioComponent",
    http_method = "GET",
    http_path = "/2020-08-01/studios/{studioId}/studio-components/{studioComponentId}",
    paginator = list()
  )
  input <- .nimblestudio$get_studio_component_input(studioComponentId = studioComponentId, studioId = studioId)
  output <- .nimblestudio$get_studio_component_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$get_studio_component <- nimblestudio_get_studio_component

#' Get a user's membership in a studio
#'
#' @description
#' Get a user's membership in a studio.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/get_studio_member.html](https://paws-r.github.io/docs/nimblestudio/get_studio_member.html) for full documentation.
#'
#' @param principalId &#91;required&#93; The principal ID. This currently supports a Amazon Web Services SSO
#' UserId.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_get_studio_member
nimblestudio_get_studio_member <- function(principalId, studioId) {
  op <- new_operation(
    name = "GetStudioMember",
    http_method = "GET",
    http_path = "/2020-08-01/studios/{studioId}/membership/{principalId}",
    paginator = list()
  )
  input <- .nimblestudio$get_studio_member_input(principalId = principalId, studioId = studioId)
  output <- .nimblestudio$get_studio_member_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$get_studio_member <- nimblestudio_get_studio_member

#' List Eula Acceptances
#'
#' @description
#' List Eula Acceptances.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/list_eula_acceptances.html](https://paws-r.github.io/docs/nimblestudio/list_eula_acceptances.html) for full documentation.
#'
#' @param eulaIds The list of EULA IDs that have been previously accepted.
#' @param nextToken The token to request the next page of results.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_list_eula_acceptances
nimblestudio_list_eula_acceptances <- function(eulaIds = NULL, nextToken = NULL, studioId) {
  op <- new_operation(
    name = "ListEulaAcceptances",
    http_method = "GET",
    http_path = "/2020-08-01/studios/{studioId}/eula-acceptances",
    paginator = list()
  )
  input <- .nimblestudio$list_eula_acceptances_input(eulaIds = eulaIds, nextToken = nextToken, studioId = studioId)
  output <- .nimblestudio$list_eula_acceptances_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$list_eula_acceptances <- nimblestudio_list_eula_acceptances

#' List Eulas
#'
#' @description
#' List Eulas.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/list_eulas.html](https://paws-r.github.io/docs/nimblestudio/list_eulas.html) for full documentation.
#'
#' @param eulaIds The list of EULA IDs that should be returned
#' @param nextToken The token to request the next page of results.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_list_eulas
nimblestudio_list_eulas <- function(eulaIds = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListEulas",
    http_method = "GET",
    http_path = "/2020-08-01/eulas",
    paginator = list()
  )
  input <- .nimblestudio$list_eulas_input(eulaIds = eulaIds, nextToken = nextToken)
  output <- .nimblestudio$list_eulas_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$list_eulas <- nimblestudio_list_eulas

#' Get all users in a given launch profile membership
#'
#' @description
#' Get all users in a given launch profile membership.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/list_launch_profile_members.html](https://paws-r.github.io/docs/nimblestudio/list_launch_profile_members.html) for full documentation.
#'
#' @param launchProfileId &#91;required&#93; The Launch Profile ID.
#' @param maxResults The max number of results to return in the response.
#' @param nextToken The token to request the next page of results.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_list_launch_profile_members
nimblestudio_list_launch_profile_members <- function(launchProfileId, maxResults = NULL, nextToken = NULL, studioId) {
  op <- new_operation(
    name = "ListLaunchProfileMembers",
    http_method = "GET",
    http_path = "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership",
    paginator = list()
  )
  input <- .nimblestudio$list_launch_profile_members_input(launchProfileId = launchProfileId, maxResults = maxResults, nextToken = nextToken, studioId = studioId)
  output <- .nimblestudio$list_launch_profile_members_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$list_launch_profile_members <- nimblestudio_list_launch_profile_members

#' List all the launch profiles a studio
#'
#' @description
#' List all the launch profiles a studio.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/list_launch_profiles.html](https://paws-r.github.io/docs/nimblestudio/list_launch_profiles.html) for full documentation.
#'
#' @param maxResults The max number of results to return in the response.
#' @param nextToken The token to request the next page of results.
#' @param principalId The principal ID. This currently supports a Amazon Web Services SSO
#' UserId.
#' @param states Filter this request to launch profiles in any of the given states.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_list_launch_profiles
nimblestudio_list_launch_profiles <- function(maxResults = NULL, nextToken = NULL, principalId = NULL, states = NULL, studioId) {
  op <- new_operation(
    name = "ListLaunchProfiles",
    http_method = "GET",
    http_path = "/2020-08-01/studios/{studioId}/launch-profiles",
    paginator = list()
  )
  input <- .nimblestudio$list_launch_profiles_input(maxResults = maxResults, nextToken = nextToken, principalId = principalId, states = states, studioId = studioId)
  output <- .nimblestudio$list_launch_profiles_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$list_launch_profiles <- nimblestudio_list_launch_profiles

#' List the streaming image resources available to this studio
#'
#' @description
#' List the streaming image resources available to this studio.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/list_streaming_images.html](https://paws-r.github.io/docs/nimblestudio/list_streaming_images.html) for full documentation.
#'
#' @param nextToken The token to request the next page of results.
#' @param owner Filter this request to streaming images with the given owner
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_list_streaming_images
nimblestudio_list_streaming_images <- function(nextToken = NULL, owner = NULL, studioId) {
  op <- new_operation(
    name = "ListStreamingImages",
    http_method = "GET",
    http_path = "/2020-08-01/studios/{studioId}/streaming-images",
    paginator = list()
  )
  input <- .nimblestudio$list_streaming_images_input(nextToken = nextToken, owner = owner, studioId = studioId)
  output <- .nimblestudio$list_streaming_images_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$list_streaming_images <- nimblestudio_list_streaming_images

#' Lists the streaming sessions in a studio
#'
#' @description
#' Lists the streaming sessions in a studio.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/list_streaming_sessions.html](https://paws-r.github.io/docs/nimblestudio/list_streaming_sessions.html) for full documentation.
#'
#' @param createdBy Filters the request to streaming sessions created by the given user.
#' @param nextToken The token to request the next page of results.
#' @param ownedBy Filters the request to streaming session owned by the given user
#' @param sessionIds Filters the request to only the provided session IDs.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_list_streaming_sessions
nimblestudio_list_streaming_sessions <- function(createdBy = NULL, nextToken = NULL, ownedBy = NULL, sessionIds = NULL, studioId) {
  op <- new_operation(
    name = "ListStreamingSessions",
    http_method = "GET",
    http_path = "/2020-08-01/studios/{studioId}/streaming-sessions",
    paginator = list()
  )
  input <- .nimblestudio$list_streaming_sessions_input(createdBy = createdBy, nextToken = nextToken, ownedBy = ownedBy, sessionIds = sessionIds, studioId = studioId)
  output <- .nimblestudio$list_streaming_sessions_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$list_streaming_sessions <- nimblestudio_list_streaming_sessions

#' Lists the StudioComponents in a studio
#'
#' @description
#' Lists the StudioComponents in a studio.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/list_studio_components.html](https://paws-r.github.io/docs/nimblestudio/list_studio_components.html) for full documentation.
#'
#' @param maxResults The max number of results to return in the response.
#' @param nextToken The token to request the next page of results.
#' @param states Filters the request to studio components that are in one of the given
#' states.
#' @param studioId &#91;required&#93; The studio ID.
#' @param types Filters the request to studio components that are of one of the given
#' types.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_list_studio_components
nimblestudio_list_studio_components <- function(maxResults = NULL, nextToken = NULL, states = NULL, studioId, types = NULL) {
  op <- new_operation(
    name = "ListStudioComponents",
    http_method = "GET",
    http_path = "/2020-08-01/studios/{studioId}/studio-components",
    paginator = list()
  )
  input <- .nimblestudio$list_studio_components_input(maxResults = maxResults, nextToken = nextToken, states = states, studioId = studioId, types = types)
  output <- .nimblestudio$list_studio_components_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$list_studio_components <- nimblestudio_list_studio_components

#' Get all users in a given studio membership
#'
#' @description
#' Get all users in a given studio membership.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/list_studio_members.html](https://paws-r.github.io/docs/nimblestudio/list_studio_members.html) for full documentation.
#'
#' @param maxResults The max number of results to return in the response.
#' @param nextToken The token to request the next page of results.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_list_studio_members
nimblestudio_list_studio_members <- function(maxResults = NULL, nextToken = NULL, studioId) {
  op <- new_operation(
    name = "ListStudioMembers",
    http_method = "GET",
    http_path = "/2020-08-01/studios/{studioId}/membership",
    paginator = list()
  )
  input <- .nimblestudio$list_studio_members_input(maxResults = maxResults, nextToken = nextToken, studioId = studioId)
  output <- .nimblestudio$list_studio_members_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$list_studio_members <- nimblestudio_list_studio_members

#' List studios in your Amazon Web Services account in the requested Amazon
#' Web Services Region
#'
#' @description
#' List studios in your Amazon Web Services account in the requested Amazon Web Services Region.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/list_studios.html](https://paws-r.github.io/docs/nimblestudio/list_studios.html) for full documentation.
#'
#' @param nextToken The token to request the next page of results.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_list_studios
nimblestudio_list_studios <- function(nextToken = NULL) {
  op <- new_operation(
    name = "ListStudios",
    http_method = "GET",
    http_path = "/2020-08-01/studios",
    paginator = list()
  )
  input <- .nimblestudio$list_studios_input(nextToken = nextToken)
  output <- .nimblestudio$list_studios_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$list_studios <- nimblestudio_list_studios

#' Gets the tags for a resource, given its Amazon Resource Names (ARN)
#'
#' @description
#' Gets the tags for a resource, given its Amazon Resource Names (ARN).
#'
#' See [https://paws-r.github.io/docs/nimblestudio/list_tags_for_resource.html](https://paws-r.github.io/docs/nimblestudio/list_tags_for_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource for which you want to
#' list tags.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_list_tags_for_resource
nimblestudio_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/2020-08-01/tags/{resourceArn}",
    paginator = list()
  )
  input <- .nimblestudio$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .nimblestudio$list_tags_for_resource_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$list_tags_for_resource <- nimblestudio_list_tags_for_resource

#' Add/update users with given persona to launch profile membership
#'
#' @description
#' Add/update users with given persona to launch profile membership.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/put_launch_profile_members.html](https://paws-r.github.io/docs/nimblestudio/put_launch_profile_members.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param identityStoreId &#91;required&#93; The ID of the identity store.
#' @param launchProfileId &#91;required&#93; The Launch Profile ID.
#' @param members &#91;required&#93; A list of members.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_put_launch_profile_members
nimblestudio_put_launch_profile_members <- function(clientToken = NULL, identityStoreId, launchProfileId, members, studioId) {
  op <- new_operation(
    name = "PutLaunchProfileMembers",
    http_method = "POST",
    http_path = "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership",
    paginator = list()
  )
  input <- .nimblestudio$put_launch_profile_members_input(clientToken = clientToken, identityStoreId = identityStoreId, launchProfileId = launchProfileId, members = members, studioId = studioId)
  output <- .nimblestudio$put_launch_profile_members_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$put_launch_profile_members <- nimblestudio_put_launch_profile_members

#' Add/update users with given persona to studio membership
#'
#' @description
#' Add/update users with given persona to studio membership.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/put_studio_members.html](https://paws-r.github.io/docs/nimblestudio/put_studio_members.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param identityStoreId &#91;required&#93; The ID of the identity store.
#' @param members &#91;required&#93; A list of members.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_put_studio_members
nimblestudio_put_studio_members <- function(clientToken = NULL, identityStoreId, members, studioId) {
  op <- new_operation(
    name = "PutStudioMembers",
    http_method = "POST",
    http_path = "/2020-08-01/studios/{studioId}/membership",
    paginator = list()
  )
  input <- .nimblestudio$put_studio_members_input(clientToken = clientToken, identityStoreId = identityStoreId, members = members, studioId = studioId)
  output <- .nimblestudio$put_studio_members_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$put_studio_members <- nimblestudio_put_studio_members

#' Transitions sessions from the STOPPED state into the READY state
#'
#' @description
#' Transitions sessions from the STOPPED state into the READY state. The START_IN_PROGRESS state is the intermediate state between the STOPPED and READY states.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/start_streaming_session.html](https://paws-r.github.io/docs/nimblestudio/start_streaming_session.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param sessionId &#91;required&#93; The streaming session ID for the StartStreamingSessionRequest.
#' @param studioId &#91;required&#93; The studio ID for the StartStreamingSessionRequest.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_start_streaming_session
nimblestudio_start_streaming_session <- function(clientToken = NULL, sessionId, studioId) {
  op <- new_operation(
    name = "StartStreamingSession",
    http_method = "POST",
    http_path = "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}/start",
    paginator = list()
  )
  input <- .nimblestudio$start_streaming_session_input(clientToken = clientToken, sessionId = sessionId, studioId = studioId)
  output <- .nimblestudio$start_streaming_session_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$start_streaming_session <- nimblestudio_start_streaming_session

#' Repairs the Amazon Web Services SSO configuration for a given studio
#'
#' @description
#' Repairs the Amazon Web Services SSO configuration for a given studio.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/start_studio_sso_configuration_repair.html](https://paws-r.github.io/docs/nimblestudio/start_studio_sso_configuration_repair.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_start_studio_sso_configuration_repair
nimblestudio_start_studio_sso_configuration_repair <- function(clientToken = NULL, studioId) {
  op <- new_operation(
    name = "StartStudioSSOConfigurationRepair",
    http_method = "PUT",
    http_path = "/2020-08-01/studios/{studioId}/sso-configuration",
    paginator = list()
  )
  input <- .nimblestudio$start_studio_sso_configuration_repair_input(clientToken = clientToken, studioId = studioId)
  output <- .nimblestudio$start_studio_sso_configuration_repair_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$start_studio_sso_configuration_repair <- nimblestudio_start_studio_sso_configuration_repair

#' Transitions sessions from the READY state into the STOPPED state
#'
#' @description
#' Transitions sessions from the READY state into the STOPPED state. The STOP_IN_PROGRESS state is the intermediate state between the READY and STOPPED states.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/stop_streaming_session.html](https://paws-r.github.io/docs/nimblestudio/stop_streaming_session.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param sessionId &#91;required&#93; The streaming session ID for the StopStreamingSessionRequest.
#' @param studioId &#91;required&#93; The studioId for the StopStreamingSessionRequest.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_stop_streaming_session
nimblestudio_stop_streaming_session <- function(clientToken = NULL, sessionId, studioId) {
  op <- new_operation(
    name = "StopStreamingSession",
    http_method = "POST",
    http_path = "/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}/stop",
    paginator = list()
  )
  input <- .nimblestudio$stop_streaming_session_input(clientToken = clientToken, sessionId = sessionId, studioId = studioId)
  output <- .nimblestudio$stop_streaming_session_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$stop_streaming_session <- nimblestudio_stop_streaming_session

#' Creates tags for a resource, given its ARN
#'
#' @description
#' Creates tags for a resource, given its ARN.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/tag_resource.html](https://paws-r.github.io/docs/nimblestudio/tag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource you want to add tags to.
#' @param tags A collection of labels, in the form of key:value pairs, that apply to
#' this resource.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_tag_resource
nimblestudio_tag_resource <- function(resourceArn, tags = NULL) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/2020-08-01/tags/{resourceArn}",
    paginator = list()
  )
  input <- .nimblestudio$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .nimblestudio$tag_resource_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$tag_resource <- nimblestudio_tag_resource

#' Deletes the tags for a resource
#'
#' @description
#' Deletes the tags for a resource.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/untag_resource.html](https://paws-r.github.io/docs/nimblestudio/untag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; Identifies the Amazon Resource Name(ARN) key from which you are removing
#' tags.
#' @param tagKeys &#91;required&#93; One or more tag keys. Specify only the tag keys, not the tag values.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_untag_resource
nimblestudio_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/2020-08-01/tags/{resourceArn}",
    paginator = list()
  )
  input <- .nimblestudio$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .nimblestudio$untag_resource_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$untag_resource <- nimblestudio_untag_resource

#' Update a launch profile
#'
#' @description
#' Update a launch profile.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/update_launch_profile.html](https://paws-r.github.io/docs/nimblestudio/update_launch_profile.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param description The description.
#' @param launchProfileId &#91;required&#93; The Launch Profile ID.
#' @param launchProfileProtocolVersions The version number of the protocol that is used by the launch profile.
#' The only valid version is "2021-03-31".
#' @param name The name for the launch profile.
#' @param streamConfiguration A configuration for a streaming session.
#' @param studioComponentIds Unique identifiers for a collection of studio components that can be
#' used with this launch profile.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_update_launch_profile
nimblestudio_update_launch_profile <- function(clientToken = NULL, description = NULL, launchProfileId, launchProfileProtocolVersions = NULL, name = NULL, streamConfiguration = NULL, studioComponentIds = NULL, studioId) {
  op <- new_operation(
    name = "UpdateLaunchProfile",
    http_method = "PATCH",
    http_path = "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}",
    paginator = list()
  )
  input <- .nimblestudio$update_launch_profile_input(clientToken = clientToken, description = description, launchProfileId = launchProfileId, launchProfileProtocolVersions = launchProfileProtocolVersions, name = name, streamConfiguration = streamConfiguration, studioComponentIds = studioComponentIds, studioId = studioId)
  output <- .nimblestudio$update_launch_profile_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$update_launch_profile <- nimblestudio_update_launch_profile

#' Update a user persona in launch profile membership
#'
#' @description
#' Update a user persona in launch profile membership.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/update_launch_profile_member.html](https://paws-r.github.io/docs/nimblestudio/update_launch_profile_member.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param launchProfileId &#91;required&#93; The Launch Profile ID.
#' @param persona &#91;required&#93; The persona.
#' @param principalId &#91;required&#93; The principal ID. This currently supports a Amazon Web Services SSO
#' UserId.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_update_launch_profile_member
nimblestudio_update_launch_profile_member <- function(clientToken = NULL, launchProfileId, persona, principalId, studioId) {
  op <- new_operation(
    name = "UpdateLaunchProfileMember",
    http_method = "PATCH",
    http_path = "/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership/{principalId}",
    paginator = list()
  )
  input <- .nimblestudio$update_launch_profile_member_input(clientToken = clientToken, launchProfileId = launchProfileId, persona = persona, principalId = principalId, studioId = studioId)
  output <- .nimblestudio$update_launch_profile_member_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$update_launch_profile_member <- nimblestudio_update_launch_profile_member

#' Update streaming image
#'
#' @description
#' Update streaming image.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/update_streaming_image.html](https://paws-r.github.io/docs/nimblestudio/update_streaming_image.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param description The description.
#' @param name The name for the streaming image.
#' @param streamingImageId &#91;required&#93; The streaming image ID.
#' @param studioId &#91;required&#93; The studio ID.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_update_streaming_image
nimblestudio_update_streaming_image <- function(clientToken = NULL, description = NULL, name = NULL, streamingImageId, studioId) {
  op <- new_operation(
    name = "UpdateStreamingImage",
    http_method = "PATCH",
    http_path = "/2020-08-01/studios/{studioId}/streaming-images/{streamingImageId}",
    paginator = list()
  )
  input <- .nimblestudio$update_streaming_image_input(clientToken = clientToken, description = description, name = name, streamingImageId = streamingImageId, studioId = studioId)
  output <- .nimblestudio$update_streaming_image_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$update_streaming_image <- nimblestudio_update_streaming_image

#' Update a Studio resource
#'
#' @description
#' Update a Studio resource.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/update_studio.html](https://paws-r.github.io/docs/nimblestudio/update_studio.html) for full documentation.
#'
#' @param adminRoleArn The IAM role that Studio Admins will assume when logging in to the
#' Nimble Studio portal.
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param displayName A friendly name for the studio.
#' @param studioId &#91;required&#93; The studio ID.
#' @param userRoleArn The IAM role that Studio Users will assume when logging in to the Nimble
#' Studio portal.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_update_studio
nimblestudio_update_studio <- function(adminRoleArn = NULL, clientToken = NULL, displayName = NULL, studioId, userRoleArn = NULL) {
  op <- new_operation(
    name = "UpdateStudio",
    http_method = "PATCH",
    http_path = "/2020-08-01/studios/{studioId}",
    paginator = list()
  )
  input <- .nimblestudio$update_studio_input(adminRoleArn = adminRoleArn, clientToken = clientToken, displayName = displayName, studioId = studioId, userRoleArn = userRoleArn)
  output <- .nimblestudio$update_studio_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$update_studio <- nimblestudio_update_studio

#' Updates a studio component resource
#'
#' @description
#' Updates a studio component resource.
#'
#' See [https://paws-r.github.io/docs/nimblestudio/update_studio_component.html](https://paws-r.github.io/docs/nimblestudio/update_studio_component.html) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If you don’t specify a client token, the AWS
#' SDK automatically generates a client token and uses it for the request
#' to ensure idempotency.
#' @param configuration The configuration of the studio component, based on component type.
#' @param description The description.
#' @param ec2SecurityGroupIds The EC2 security groups that control access to the studio component.
#' @param initializationScripts Initialization scripts for studio components.
#' @param name The name for the studio component.
#' @param runtimeRoleArn An IAM role attached to a Studio Component that gives the studio
#' component access to AWS resources at anytime while the instance is
#' running.
#' @param scriptParameters Parameters for the studio component scripts.
#' @param secureInitializationRoleArn An IAM role attached to Studio Component when the system initialization
#' script runs which give the studio component access to AWS resources when
#' the system initialization script runs.
#' @param studioComponentId &#91;required&#93; The studio component ID.
#' @param studioId &#91;required&#93; The studio ID.
#' @param subtype The specific subtype of a studio component.
#' @param type The type of the studio component.
#'
#' @keywords internal
#'
#' @rdname nimblestudio_update_studio_component
nimblestudio_update_studio_component <- function(clientToken = NULL, configuration = NULL, description = NULL, ec2SecurityGroupIds = NULL, initializationScripts = NULL, name = NULL, runtimeRoleArn = NULL, scriptParameters = NULL, secureInitializationRoleArn = NULL, studioComponentId, studioId, subtype = NULL, type = NULL) {
  op <- new_operation(
    name = "UpdateStudioComponent",
    http_method = "PATCH",
    http_path = "/2020-08-01/studios/{studioId}/studio-components/{studioComponentId}",
    paginator = list()
  )
  input <- .nimblestudio$update_studio_component_input(clientToken = clientToken, configuration = configuration, description = description, ec2SecurityGroupIds = ec2SecurityGroupIds, initializationScripts = initializationScripts, name = name, runtimeRoleArn = runtimeRoleArn, scriptParameters = scriptParameters, secureInitializationRoleArn = secureInitializationRoleArn, studioComponentId = studioComponentId, studioId = studioId, subtype = subtype, type = type)
  output <- .nimblestudio$update_studio_component_output()
  config <- get_config()
  svc <- .nimblestudio$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.nimblestudio$operations$update_studio_component <- nimblestudio_update_studio_component
