% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_test_availability_configuration}
\alias{workmail_test_availability_configuration}
\title{Performs a test on an availability provider to ensure that access is
allowed}
\usage{
workmail_test_availability_configuration(
  OrganizationId,
  DomainName = NULL,
  EwsProvider = NULL,
  LambdaProvider = NULL
)
}
\arguments{
\item{OrganizationId}{[required] The Amazon WorkMail organization where the availability provider will be
tested.}

\item{DomainName}{The domain to which the provider applies. If this field is provided, a
stored availability provider associated to this domain name will be
tested.}

\item{EwsProvider}{}

\item{LambdaProvider}{}
}
\description{
Performs a test on an availability provider to ensure that access is allowed. For EWS, it verifies the provided credentials can be used to successfully log in. For Lambda, it verifies that the Lambda function can be invoked and that the resource access policy was configured to deny anonymous access. An anonymous invocation is one done without providing either a \code{SourceArn} or \code{SourceAccount} header.

See \url{https://paws-r.github.io/docs/workmail/test_availability_configuration.html} for full documentation.
}
\keyword{internal}
