% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_create_user}
\alias{workmail_create_user}
\title{Creates a user who can be used in WorkMail by calling the
RegisterToWorkMail operation}
\usage{
workmail_create_user(
  OrganizationId,
  Name,
  DisplayName,
  Password = NULL,
  Role = NULL,
  FirstName = NULL,
  LastName = NULL,
  HiddenFromGlobalAddressList = NULL
)
}
\arguments{
\item{OrganizationId}{[required] The identifier of the organization for which the user is created.}

\item{Name}{[required] The name for the new user. WorkMail directory user names have a maximum
length of 64. All others have a maximum length of 20.}

\item{DisplayName}{[required] The display name for the new user.}

\item{Password}{The password for the new user.}

\item{Role}{The role of the new user.

You cannot pass \emph{SYSTEM_USER} or \emph{RESOURCE} role in a single request.
When a user role is not selected, the default role of \emph{USER} is
selected.}

\item{FirstName}{The first name of the new user.}

\item{LastName}{The last name of the new user.}

\item{HiddenFromGlobalAddressList}{If this parameter is enabled, the user will be hidden from the address
book.}
}
\description{
Creates a user who can be used in WorkMail by calling the \code{\link[=workmail_register_to_work_mail]{register_to_work_mail}} operation.

See \url{https://www.paws-r-sdk.com/docs/workmail_create_user/} for full documentation.
}
\keyword{internal}
