% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_get_bots}
\alias{lexmodelbuildingservice_get_bots}
\title{Returns bot information as follows: - If you provide the nameContains
field, the response includes information for the $LATEST version of all
bots whose name contains the specified string}
\usage{
lexmodelbuildingservice_get_bots(nextToken, maxResults, nameContains)
}
\arguments{
\item{nextToken}{A pagination token that fetches the next page of bots. If the response
to this call is truncated, Amazon Lex returns a pagination token in the
response. To fetch the next page of bots, specify the pagination token
in the next request.}

\item{maxResults}{The maximum number of bots to return in the response that the request
will return. The default is 10.}

\item{nameContains}{Substring to match in bot names. A bot will be returned if any part of
its name matches the substring. For example, "xyz" matches both "xyzabc"
and "abcxyz."}
}
\description{
Returns bot information as follows:
\itemize{
\item If you provide the \code{nameContains} field, the response includes
information for the \verb{$LATEST} version of all bots whose name
contains the specified string.
\item If you don't specify the \code{nameContains} field, the operation returns
information about the \verb{$LATEST} version of all of your bots.
}

This operation requires permission for the \code{lex:GetBots} action.
}
\section{Request syntax}{
\preformatted{svc$get_bots(
  nextToken = "string",
  maxResults = 123,
  nameContains = "string"
)
}
}

\examples{
\dontrun{
# This example shows how to get a list of all of the bots in your account.
svc$get_bots(
  maxResults = 5L,
  nextToken = ""
)
}

}
\keyword{internal}
