% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning_operations.R
\name{machinelearning_update_ml_model}
\alias{machinelearning_update_ml_model}
\title{Updates the MLModelName and the ScoreThreshold of an MLModel}
\usage{
machinelearning_update_ml_model(MLModelId, MLModelName, ScoreThreshold)
}
\arguments{
\item{MLModelId}{[required] The ID assigned to the \code{MLModel} during creation.}

\item{MLModelName}{A user-supplied name or description of the \code{MLModel}.}

\item{ScoreThreshold}{The \code{ScoreThreshold} used in binary classification \code{MLModel} that marks
the boundary between a positive prediction and a negative prediction.

Output values greater than or equal to the \code{ScoreThreshold} receive a
positive result from the \code{MLModel}, such as \code{true}. Output values less
than the \code{ScoreThreshold} receive a negative response from the
\code{MLModel}, such as \code{false}.}
}
\description{
Updates the \code{MLModelName} and the \code{ScoreThreshold} of an \code{MLModel}.

You can use the \code{GetMLModel} operation to view the contents of the
updated data element.
}
\section{Request syntax}{
\preformatted{svc$update_ml_model(
  MLModelId = "string",
  MLModelName = "string",
  ScoreThreshold = 123.0
)
}
}

\keyword{internal}
