% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_notebook_instance}
\alias{sagemaker_create_notebook_instance}
\title{Creates an Amazon SageMaker notebook instance}
\usage{
sagemaker_create_notebook_instance(NotebookInstanceName, InstanceType,
  SubnetId, SecurityGroupIds, RoleArn, KmsKeyId, Tags,
  LifecycleConfigName, DirectInternetAccess, VolumeSizeInGB,
  AcceleratorTypes, DefaultCodeRepository, AdditionalCodeRepositories,
  RootAccess)
}
\arguments{
\item{NotebookInstanceName}{[required] The name of the new notebook instance.}

\item{InstanceType}{[required] The type of ML compute instance to launch for the notebook instance.}

\item{SubnetId}{The ID of the subnet in a VPC to which you would like to have a
connectivity from your ML compute instance.}

\item{SecurityGroupIds}{The VPC security group IDs, in the form sg-xxxxxxxx. The security groups
must be for the same VPC as specified in the subnet.}

\item{RoleArn}{[required] When you send any requests to AWS resources from the notebook instance,
Amazon SageMaker assumes this role to perform tasks on your behalf. You
must grant this role necessary permissions so Amazon SageMaker can
perform these tasks. The policy must allow the Amazon SageMaker service
principal (sagemaker.amazonaws.com) permissions to assume this role. For
more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html}{Amazon SageMaker Roles}.

To be able to pass this role to Amazon SageMaker, the caller of this API
must have the \code{iam:PassRole} permission.}

\item{KmsKeyId}{The Amazon Resource Name (ARN) of a AWS Key Management Service key that
Amazon SageMaker uses to encrypt data on the storage volume attached to
your notebook instance. The KMS key you provide must be enabled. For
information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html}{Enabling and Disabling Keys}
in the \emph{AWS Key Management Service Developer Guide}.}

\item{Tags}{An array of key-value pairs. You can use tags to categorize your AWS
resources in different ways, for example, by purpose, owner, or
environment. For more information, see \href{https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html}{Tagging AWS Resources}.}

\item{LifecycleConfigName}{The name of a lifecycle configuration to associate with the notebook
instance. For information about lifestyle configurations, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html}{Step 2.1: (Optional) Customize a Notebook Instance}.}

\item{DirectInternetAccess}{Sets whether Amazon SageMaker provides internet access to the notebook
instance. If you set this to \code{Disabled} this notebook instance will be
able to access resources only in your VPC, and will not be able to
connect to Amazon SageMaker training and endpoint services unless your
configure a NAT Gateway in your VPC.

For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/#appendix-notebook-and-internet-access}{Notebook Instances Are Internet-Enabled by Default}.
You can set the value of this parameter to \code{Disabled} only if you set a
value for the \code{SubnetId} parameter.}

\item{VolumeSizeInGB}{The size, in GB, of the ML storage volume to attach to the notebook
instance. The default value is 5 GB.}

\item{AcceleratorTypes}{A list of Elastic Inference (EI) instance types to associate with this
notebook instance. Currently, only one instance type can be associated
with a notebook instance. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html}{Using Elastic Inference in Amazon SageMaker}.}

\item{DefaultCodeRepository}{A Git repository to associate with the notebook instance as its default
code repository. This can be either the name of a Git repository stored
as a resource in your account, or the URL of a Git repository in \href{https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html}{AWS CodeCommit}
or in any other Git repository. When you open a notebook instance, it
opens in the directory that contains this repository. For more
information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html}{Associating Git Repositories with Amazon SageMaker Notebook Instances}.}

\item{AdditionalCodeRepositories}{An array of up to three Git repositories to associate with the notebook
instance. These can be either the names of Git repositories stored as
resources in your account, or the URL of Git repositories in \href{https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html}{AWS CodeCommit}
or in any other Git repository. These repositories are cloned at the
same level as the default repository of your notebook instance. For more
information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html}{Associating Git Repositories with Amazon SageMaker Notebook Instances}.}

\item{RootAccess}{Whether root access is enabled or disabled for users of the notebook
instance. The default value is \code{Enabled}.

Lifecycle configurations need root access to be able to set up a
notebook instance. Because of this, lifecycle configurations associated
with a notebook instance always run with root access even if you disable
root access for users.}
}
\description{
Creates an Amazon SageMaker notebook instance. A notebook instance is a
machine learning (ML) compute instance running on a Jupyter notebook.

In a \code{CreateNotebookInstance} request, specify the type of ML compute
instance that you want to run. Amazon SageMaker launches the instance,
installs common libraries that you can use to explore datasets for model
training, and attaches an ML storage volume to the notebook instance.

Amazon SageMaker also provides a set of example notebooks. Each notebook
demonstrates how to use Amazon SageMaker with a specific algorithm or
with a machine learning framework.

After receiving the request, Amazon SageMaker does the following:
\enumerate{
\item Creates a network interface in the Amazon SageMaker VPC.
\item (Option) If you specified \code{SubnetId}, Amazon SageMaker creates a
network interface in your own VPC, which is inferred from the subnet
ID that you provide in the input. When creating this network
interface, Amazon SageMaker attaches the security group that you
specified in the request to the network interface that it creates in
your VPC.
\item Launches an EC2 instance of the type specified in the request in the
Amazon SageMaker VPC. If you specified \code{SubnetId} of your VPC,
Amazon SageMaker specifies both network interfaces when launching
this instance. This enables inbound traffic from your own VPC to the
notebook instance, assuming that the security groups allow it.
}

After creating the notebook instance, Amazon SageMaker returns its
Amazon Resource Name (ARN). You can't change the name of a notebook
instance after you create it.

After Amazon SageMaker creates the notebook instance, you can connect to
the Jupyter server and work in Jupyter notebooks. For example, you can
write code to explore a dataset that you can use for model training,
train a model, host models by creating Amazon SageMaker endpoints, and
validate hosted models.

For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/}{How It Works}.
}
\section{Request syntax}{
\preformatted{svc$create_notebook_instance(
  NotebookInstanceName = "string",
  InstanceType = "ml.t2.medium"|"ml.t2.large"|"ml.t2.xlarge"|"ml.t2.2xlarge"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.c5d.xlarge"|"ml.c5d.2xlarge"|"ml.c5d.4xlarge"|"ml.c5d.9xlarge"|"ml.c5d.18xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge",
  SubnetId = "string",
  SecurityGroupIds = list(
    "string"
  ),
  RoleArn = "string",
  KmsKeyId = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  LifecycleConfigName = "string",
  DirectInternetAccess = "Enabled"|"Disabled",
  VolumeSizeInGB = 123,
  AcceleratorTypes = list(
    "ml.eia1.medium"|"ml.eia1.large"|"ml.eia1.xlarge"|"ml.eia2.medium"|"ml.eia2.large"|"ml.eia2.xlarge"
  ),
  DefaultCodeRepository = "string",
  AdditionalCodeRepositories = list(
    "string"
  ),
  RootAccess = "Enabled"|"Disabled"
)
}
}

\keyword{internal}
