% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_workforce}
\alias{sagemaker_create_workforce}
\title{Use this operation to create a workforce}
\usage{
sagemaker_create_workforce(CognitoConfig, OidcConfig, SourceIpConfig,
  WorkforceName, Tags)
}
\arguments{
\item{CognitoConfig}{Use this parameter to configure an Amazon Cognito private workforce. A
single Cognito workforce is created using and corresponds to a single
\href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html}{Amazon Cognito user pool}.

Do not use \code{OidcConfig} if you specify values for \code{CognitoConfig}.}

\item{OidcConfig}{Use this parameter to configure a private workforce using your own OIDC
Identity Provider.

Do not use \code{CognitoConfig} if you specify values for \code{OidcConfig}.}

\item{SourceIpConfig}{}

\item{WorkforceName}{[required] The name of the private workforce.}

\item{Tags}{An array of key-value pairs that contain metadata to help you categorize
and organize our workforce. Each tag consists of a key and a value, both
of which you define.}
}
\description{
Use this operation to create a workforce. This operation will return an
error if a workforce already exists in the AWS Region that you specify.
You can only create one workforce in each AWS Region per AWS account.

If you want to create a new workforce in an AWS Region where a workforce
already exists, use the API operation to delete the existing workforce
and then use \code{CreateWorkforce} to create a new workforce.

To create a private workforce using Amazon Cognito, you must specify a
Cognito user pool in \code{CognitoConfig}. You can also create an Amazon
Cognito workforce using the Amazon SageMaker console. For more
information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html}{Create a Private Workforce (Amazon Cognito)}.

To create a private workforce using your own OIDC Identity Provider
(IdP), specify your IdP configuration in \code{OidcConfig}. Your OIDC IdP
must support \emph{groups} because groups are used by Ground Truth and Amazon
A2I to create work teams. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private-oidc.html}{Create a Private Workforce (OIDC IdP)}.
}
\section{Request syntax}{
\preformatted{svc$create_workforce(
  CognitoConfig = list(
    UserPool = "string",
    ClientId = "string"
  ),
  OidcConfig = list(
    ClientId = "string",
    ClientSecret = "string",
    Issuer = "string",
    AuthorizationEndpoint = "string",
    TokenEndpoint = "string",
    UserInfoEndpoint = "string",
    LogoutEndpoint = "string",
    JwksUri = "string"
  ),
  SourceIpConfig = list(
    Cidrs = list(
      "string"
    )
  ),
  WorkforceName = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
