% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_describe_project_versions}
\alias{rekognition_describe_project_versions}
\title{Lists and describes the models in an Amazon Rekognition Custom Labels
project}
\usage{
rekognition_describe_project_versions(ProjectArn, VersionNames,
  NextToken, MaxResults)
}
\arguments{
\item{ProjectArn}{[required] The Amazon Resource Name (ARN) of the project that contains the models
you want to describe.}

\item{VersionNames}{A list of model version names that you want to describe. You can add up
to 10 model version names to the list. If you don't specify a value, all
model descriptions are returned. A version name is part of a model
(ProjectVersion) ARN. For example, \verb{my-model.2020-01-21T09.10.15} is the
version name in the following ARN.
\verb{arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/my-model.2020-01-21T09.10.15/1234567890123}.}

\item{NextToken}{If the previous response was incomplete (because there is more results
to retrieve), Amazon Rekognition Custom Labels returns a pagination
token in the response. You can use this pagination token to retrieve the
next set of results.}

\item{MaxResults}{The maximum number of results to return per paginated call. The largest
value you can specify is 100. If you specify a value greater than 100, a
ValidationException error occurs. The default value is 100.}
}
\value{
A list with the following syntax:\preformatted{list(
  ProjectVersionDescriptions = list(
    list(
      ProjectVersionArn = "string",
      CreationTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      MinInferenceUnits = 123,
      Status = "TRAINING_IN_PROGRESS"|"TRAINING_COMPLETED"|"TRAINING_FAILED"|"STARTING"|"RUNNING"|"FAILED"|"STOPPING"|"STOPPED"|"DELETING",
      StatusMessage = "string",
      BillableTrainingTimeInSeconds = 123,
      TrainingEndTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      OutputConfig = list(
        S3Bucket = "string",
        S3KeyPrefix = "string"
      ),
      TrainingDataResult = list(
        Input = list(
          Assets = list(
            list(
              GroundTruthManifest = list(
                S3Object = list(
                  Bucket = "string",
                  Name = "string",
                  Version = "string"
                )
              )
            )
          )
        ),
        Output = list(
          Assets = list(
            list(
              GroundTruthManifest = list(
                S3Object = list(
                  Bucket = "string",
                  Name = "string",
                  Version = "string"
                )
              )
            )
          )
        ),
        Validation = list(
          Assets = list(
            list(
              GroundTruthManifest = list(
                S3Object = list(
                  Bucket = "string",
                  Name = "string",
                  Version = "string"
                )
              )
            )
          )
        )
      ),
      TestingDataResult = list(
        Input = list(
          Assets = list(
            list(
              GroundTruthManifest = list(
                S3Object = list(
                  Bucket = "string",
                  Name = "string",
                  Version = "string"
                )
              )
            )
          ),
          AutoCreate = TRUE|FALSE
        ),
        Output = list(
          Assets = list(
            list(
              GroundTruthManifest = list(
                S3Object = list(
                  Bucket = "string",
                  Name = "string",
                  Version = "string"
                )
              )
            )
          ),
          AutoCreate = TRUE|FALSE
        ),
        Validation = list(
          Assets = list(
            list(
              GroundTruthManifest = list(
                S3Object = list(
                  Bucket = "string",
                  Name = "string",
                  Version = "string"
                )
              )
            )
          )
        )
      ),
      EvaluationResult = list(
        F1Score = 123.0,
        Summary = list(
          S3Object = list(
            Bucket = "string",
            Name = "string",
            Version = "string"
          )
        )
      ),
      ManifestSummary = list(
        S3Object = list(
          Bucket = "string",
          Name = "string",
          Version = "string"
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists and describes the models in an Amazon Rekognition Custom Labels
project. You can specify up to 10 model versions in
\code{ProjectVersionArns}. If you don't specify a value, descriptions for all
models are returned.

This operation requires permissions to perform the
\code{rekognition:DescribeProjectVersions} action.
}
\section{Request syntax}{
\preformatted{svc$describe_project_versions(
  ProjectArn = "string",
  VersionNames = list(
    "string"
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
