% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_describe_device}
\alias{sagemaker_describe_device}
\title{Describes the device}
\usage{
sagemaker_describe_device(NextToken, DeviceName, DeviceFleetName)
}
\arguments{
\item{NextToken}{Next token of device description.}

\item{DeviceName}{[required] The unique ID of the device.}

\item{DeviceFleetName}{[required] The name of the fleet the devices belong to.}
}
\value{
A list with the following syntax:\preformatted{list(
  DeviceArn = "string",
  DeviceName = "string",
  Description = "string",
  DeviceFleetName = "string",
  IotThingName = "string",
  RegistrationTime = as.POSIXct(
    "2015-01-01"
  ),
  LatestHeartbeat = as.POSIXct(
    "2015-01-01"
  ),
  Models = list(
    list(
      ModelName = "string",
      ModelVersion = "string",
      LatestSampleTime = as.POSIXct(
        "2015-01-01"
      ),
      LatestInference = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  MaxModels = 123,
  NextToken = "string"
)
}
}
\description{
Describes the device.
}
\section{Request syntax}{
\preformatted{svc$describe_device(
  NextToken = "string",
  DeviceName = "string",
  DeviceFleetName = "string"
)
}
}

\keyword{internal}
