% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_list_medical_vocabularies}
\alias{transcribeservice_list_medical_vocabularies}
\title{Returns a list of vocabularies that match the specified criteria}
\usage{
transcribeservice_list_medical_vocabularies(NextToken, MaxResults,
  StateEquals, NameContains)
}
\arguments{
\item{NextToken}{If the result of your previous request to
\code{\link[=transcribeservice_list_medical_vocabularies]{list_medical_vocabularies}}
was truncated, include the \code{NextToken} to fetch the next set of
vocabularies.}

\item{MaxResults}{The maximum number of vocabularies to return in the response.}

\item{StateEquals}{When specified, returns only vocabularies with the \code{VocabularyState}
equal to the specified vocabulary state. Use this field to see which
vocabularies are ready for your medical transcription jobs.}

\item{NameContains}{Returns vocabularies whose names contain the specified string. The
search is not case sensitive.
\code{\link[=transcribeservice_list_medical_vocabularies]{list_medical_vocabularies}}
returns both "\code{vocabularyname}" and "\code{VocabularyName}".}
}
\value{
A list with the following syntax:\preformatted{list(
  Status = "PENDING"|"READY"|"FAILED",
  NextToken = "string",
  Vocabularies = list(
    list(
      VocabularyName = "string",
      LanguageCode = "af-ZA"|"ar-AE"|"ar-SA"|"cy-GB"|"da-DK"|"de-CH"|"de-DE"|"en-AB"|"en-AU"|"en-GB"|"en-IE"|"en-IN"|"en-US"|"en-WL"|"es-ES"|"es-US"|"fa-IR"|"fr-CA"|"fr-FR"|"ga-IE"|"gd-GB"|"he-IL"|"hi-IN"|"id-ID"|"it-IT"|"ja-JP"|"ko-KR"|"ms-MY"|"nl-NL"|"pt-BR"|"pt-PT"|"ru-RU"|"ta-IN"|"te-IN"|"tr-TR"|"zh-CN",
      LastModifiedTime = as.POSIXct(
        "2015-01-01"
      ),
      VocabularyState = "PENDING"|"READY"|"FAILED"
    )
  )
)
}
}
\description{
Returns a list of vocabularies that match the specified criteria. If you
don't enter a value in any of the request parameters, returns the entire
list of vocabularies.
}
\section{Request syntax}{
\preformatted{svc$list_medical_vocabularies(
  NextToken = "string",
  MaxResults = 123,
  StateEquals = "PENDING"|"READY"|"FAILED",
  NameContains = "string"
)
}
}

\keyword{internal}
