% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_get_intent_versions}
\alias{lexmodelbuildingservice_get_intent_versions}
\title{Gets information about all of the versions of an intent}
\usage{
lexmodelbuildingservice_get_intent_versions(name, nextToken, maxResults)
}
\arguments{
\item{name}{[required] The name of the intent for which versions should be returned.}

\item{nextToken}{A pagination token for fetching the next page of intent versions. If the
response to this call is truncated, Amazon Lex returns a pagination
token in the response. To fetch the next page of versions, specify the
pagination token in the next request.}

\item{maxResults}{The maximum number of intent versions to return in the response. The
default is 10.}
}
\value{
A list with the following syntax:\preformatted{list(
  intents = list(
    list(
      name = "string",
      description = "string",
      lastUpdatedDate = as.POSIXct(
        "2015-01-01"
      ),
      createdDate = as.POSIXct(
        "2015-01-01"
      ),
      version = "string"
    )
  ),
  nextToken = "string"
)
}
}
\description{
Gets information about all of the versions of an intent.

The \code{\link[=lexmodelbuildingservice_get_intent_versions]{get_intent_versions}}
operation returns an \code{IntentMetadata} object for each version of an
intent. For example, if an intent has three numbered versions, the
\code{\link[=lexmodelbuildingservice_get_intent_versions]{get_intent_versions}}
operation returns four \code{IntentMetadata} objects in the response, one for
each numbered version and one for the \verb{$LATEST} version.

The \code{\link[=lexmodelbuildingservice_get_intent_versions]{get_intent_versions}}
operation always returns at least one version, the \verb{$LATEST} version.

This operation requires permissions for the \code{lex:GetIntentVersions}
action.
}
\section{Request syntax}{
\preformatted{svc$get_intent_versions(
  name = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
