% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_stop_project_version}
\alias{rekognition_stop_project_version}
\title{Stops a running model}
\usage{
rekognition_stop_project_version(ProjectVersionArn)
}
\arguments{
\item{ProjectVersionArn}{[required] The Amazon Resource Name (ARN) of the model version that you want to
delete.

This operation requires permissions to perform the
\code{rekognition:StopProjectVersion} action.}
}
\value{
A list with the following syntax:\preformatted{list(
  Status = "TRAINING_IN_PROGRESS"|"TRAINING_COMPLETED"|"TRAINING_FAILED"|"STARTING"|"RUNNING"|"FAILED"|"STOPPING"|"STOPPED"|"DELETING"
)
}
}
\description{
Stops a running model. The operation might take a while to complete. To
check the current status, call
\code{\link[=rekognition_describe_project_versions]{describe_project_versions}}.
}
\section{Request syntax}{
\preformatted{svc$stop_project_version(
  ProjectVersionArn = "string"
)
}
}

\keyword{internal}
