% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_presigned_notebook_instance_url}
\alias{sagemaker_create_presigned_notebook_instance_url}
\title{Returns a URL that you can use to connect to the Jupyter server from a
notebook instance}
\usage{
sagemaker_create_presigned_notebook_instance_url(NotebookInstanceName,
  SessionExpirationDurationInSeconds)
}
\arguments{
\item{NotebookInstanceName}{[required] The name of the notebook instance.}

\item{SessionExpirationDurationInSeconds}{The duration of the session, in seconds. The default is 12 hours.}
}
\value{
A list with the following syntax:\preformatted{list(
  AuthorizedUrl = "string"
)
}
}
\description{
Returns a URL that you can use to connect to the Jupyter server from a
notebook instance. In the Amazon SageMaker console, when you choose
\code{Open} next to a notebook instance, Amazon SageMaker opens a new tab
showing the Jupyter server home page from the notebook instance. The
console uses this API to get the URL and show the page.

The IAM role or user used to call this API defines the permissions to
access the notebook instance. Once the presigned URL is created, no
additional permission is required to access this URL. IAM authorization
policies for this API are also enforced for every HTTP request and
WebSocket frame that attempts to connect to the notebook instance.

You can restrict access to this API and to the URL that it returns to a
list of IP addresses that you specify. Use the \code{NotIpAddress} condition
operator and the \code{aws:SourceIP} condition context key to specify the
list of IP addresses that you want to have access to the notebook
instance. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter}{Limit Access to a Notebook Instance by IP Address}.

The URL that you get from a call to
\code{\link[=sagemaker_create_presigned_notebook_instance_url]{create_presigned_notebook_instance_url}}
is valid only for 5 minutes. If you try to use the URL after the
5-minute limit expires, you are directed to the AWS console sign-in
page.
}
\section{Request syntax}{
\preformatted{svc$create_presigned_notebook_instance_url(
  NotebookInstanceName = "string",
  SessionExpirationDurationInSeconds = 123
)
}
}

\keyword{internal}
