% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_delete_workforce}
\alias{sagemaker_delete_workforce}
\title{Use this operation to delete a workforce}
\usage{
sagemaker_delete_workforce(WorkforceName)
}
\arguments{
\item{WorkforceName}{[required] The name of the workforce.}
}
\value{
An empty list.
}
\description{
Use this operation to delete a workforce.

If you want to create a new workforce in an AWS Region where a workforce
already exists, use this operation to delete the existing workforce and
then use to create a new workforce.

If a private workforce contains one or more work teams, you must use the
operation to delete all work teams before you delete the workforce. If
you try to delete a workforce that contains one or more work teams, you
will recieve a \code{ResourceInUse} error.
}
\section{Request syntax}{
\preformatted{svc$delete_workforce(
  WorkforceName = "string"
)
}
}

\keyword{internal}
