% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_describe_auto_ml_job}
\alias{sagemaker_describe_auto_ml_job}
\title{Returns information about an Amazon SageMaker job}
\usage{
sagemaker_describe_auto_ml_job(AutoMLJobName)
}
\arguments{
\item{AutoMLJobName}{[required] Request information about a job using that job's unique name.}
}
\value{
A list with the following syntax:\preformatted{list(
  AutoMLJobName = "string",
  AutoMLJobArn = "string",
  InputDataConfig = list(
    list(
      DataSource = list(
        S3DataSource = list(
          S3DataType = "ManifestFile"|"S3Prefix",
          S3Uri = "string"
        )
      ),
      CompressionType = "None"|"Gzip",
      TargetAttributeName = "string"
    )
  ),
  OutputDataConfig = list(
    KmsKeyId = "string",
    S3OutputPath = "string"
  ),
  RoleArn = "string",
  AutoMLJobObjective = list(
    MetricName = "Accuracy"|"MSE"|"F1"|"F1macro"|"AUC"
  ),
  ProblemType = "BinaryClassification"|"MulticlassClassification"|"Regression",
  AutoMLJobConfig = list(
    CompletionCriteria = list(
      MaxCandidates = 123,
      MaxRuntimePerTrainingJobInSeconds = 123,
      MaxAutoMLJobRuntimeInSeconds = 123
    ),
    SecurityConfig = list(
      VolumeKmsKeyId = "string",
      EnableInterContainerTrafficEncryption = TRUE|FALSE,
      VpcConfig = list(
        SecurityGroupIds = list(
          "string"
        ),
        Subnets = list(
          "string"
        )
      )
    )
  ),
  CreationTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedTime = as.POSIXct(
    "2015-01-01"
  ),
  FailureReason = "string",
  BestCandidate = list(
    CandidateName = "string",
    FinalAutoMLJobObjectiveMetric = list(
      Type = "Maximize"|"Minimize",
      MetricName = "Accuracy"|"MSE"|"F1"|"F1macro"|"AUC",
      Value = 123.0
    ),
    ObjectiveStatus = "Succeeded"|"Pending"|"Failed",
    CandidateSteps = list(
      list(
        CandidateStepType = "AWS::SageMaker::TrainingJob"|"AWS::SageMaker::TransformJob"|"AWS::SageMaker::ProcessingJob",
        CandidateStepArn = "string",
        CandidateStepName = "string"
      )
    ),
    CandidateStatus = "Completed"|"InProgress"|"Failed"|"Stopped"|"Stopping",
    InferenceContainers = list(
      list(
        Image = "string",
        ModelDataUrl = "string",
        Environment = list(
          "string"
        )
      )
    ),
    CreationTime = as.POSIXct(
      "2015-01-01"
    ),
    EndTime = as.POSIXct(
      "2015-01-01"
    ),
    LastModifiedTime = as.POSIXct(
      "2015-01-01"
    ),
    FailureReason = "string"
  ),
  AutoMLJobStatus = "Completed"|"InProgress"|"Failed"|"Stopped"|"Stopping",
  AutoMLJobSecondaryStatus = "Starting"|"AnalyzingData"|"FeatureEngineering"|"ModelTuning"|"MaxCandidatesReached"|"Failed"|"Stopped"|"MaxAutoMLJobRuntimeReached"|"Stopping"|"CandidateDefinitionsGenerated",
  GenerateCandidateDefinitionsOnly = TRUE|FALSE,
  AutoMLJobArtifacts = list(
    CandidateDefinitionNotebookLocation = "string",
    DataExplorationNotebookLocation = "string"
  ),
  ResolvedAttributes = list(
    AutoMLJobObjective = list(
      MetricName = "Accuracy"|"MSE"|"F1"|"F1macro"|"AUC"
    ),
    ProblemType = "BinaryClassification"|"MulticlassClassification"|"Regression",
    CompletionCriteria = list(
      MaxCandidates = 123,
      MaxRuntimePerTrainingJobInSeconds = 123,
      MaxAutoMLJobRuntimeInSeconds = 123
    )
  )
)
}
}
\description{
Returns information about an Amazon SageMaker job.
}
\section{Request syntax}{
\preformatted{svc$describe_auto_ml_job(
  AutoMLJobName = "string"
)
}
}

\keyword{internal}
