# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include translate_service.R
NULL

#' A synchronous action that deletes a custom terminology
#'
#' A synchronous action that deletes a custom terminology.
#'
#' @usage
#' translate_delete_terminology(Name)
#'
#' @param Name &#91;required&#93; The name of the custom terminology being deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_terminology(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname translate_delete_terminology
translate_delete_terminology <- function(Name) {
  op <- new_operation(
    name = "DeleteTerminology",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .translate$delete_terminology_input(Name = Name)
  output <- .translate$delete_terminology_output()
  svc <- .translate$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$delete_terminology <- translate_delete_terminology

#' Retrieves a custom terminology
#'
#' Retrieves a custom terminology.
#'
#' @usage
#' translate_get_terminology(Name, TerminologyDataFormat)
#'
#' @param Name &#91;required&#93; The name of the custom terminology being retrieved.
#' @param TerminologyDataFormat &#91;required&#93; The data format of the custom terminology being retrieved, either CSV or
#' TMX.
#'
#' @section Request syntax:
#' ```
#' svc$get_terminology(
#'   Name = "string",
#'   TerminologyDataFormat = "CSV"|"TMX"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname translate_get_terminology
translate_get_terminology <- function(Name, TerminologyDataFormat) {
  op <- new_operation(
    name = "GetTerminology",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .translate$get_terminology_input(Name = Name, TerminologyDataFormat = TerminologyDataFormat)
  output <- .translate$get_terminology_output()
  svc <- .translate$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$get_terminology <- translate_get_terminology

#' Creates or updates a custom terminology, depending on whether or not one
#' already exists for the given terminology name
#'
#' Creates or updates a custom terminology, depending on whether or not one
#' already exists for the given terminology name. Importing a terminology
#' with the same name as an existing one will merge the terminologies based
#' on the chosen merge strategy. Currently, the only supported merge
#' strategy is OVERWRITE, and so the imported terminology will overwrite an
#' existing terminology of the same name.
#' 
#' If you import a terminology that overwrites an existing one, the new
#' terminology take up to 10 minutes to fully propagate and be available
#' for use in a translation due to cache policies with the DataPlane
#' service that performs the translations.
#'
#' @usage
#' translate_import_terminology(Name, MergeStrategy, Description,
#'   TerminologyData, EncryptionKey)
#'
#' @param Name &#91;required&#93; The name of the custom terminology being imported.
#' @param MergeStrategy &#91;required&#93; The merge strategy of the custom terminology being imported. Currently,
#' only the OVERWRITE merge strategy is supported. In this case, the
#' imported terminology will overwrite an existing terminology of the same
#' name.
#' @param Description The description of the custom terminology being imported.
#' @param TerminologyData &#91;required&#93; The terminology data for the custom terminology being imported.
#' @param EncryptionKey The encryption key for the custom terminology being imported.
#'
#' @section Request syntax:
#' ```
#' svc$import_terminology(
#'   Name = "string",
#'   MergeStrategy = "OVERWRITE",
#'   Description = "string",
#'   TerminologyData = list(
#'     File = raw,
#'     Format = "CSV"|"TMX"
#'   ),
#'   EncryptionKey = list(
#'     Type = "KMS",
#'     Id = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname translate_import_terminology
translate_import_terminology <- function(Name, MergeStrategy, Description = NULL, TerminologyData, EncryptionKey = NULL) {
  op <- new_operation(
    name = "ImportTerminology",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .translate$import_terminology_input(Name = Name, MergeStrategy = MergeStrategy, Description = Description, TerminologyData = TerminologyData, EncryptionKey = EncryptionKey)
  output <- .translate$import_terminology_output()
  svc <- .translate$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$import_terminology <- translate_import_terminology

#' Provides a list of custom terminologies associated with your account
#'
#' Provides a list of custom terminologies associated with your account.
#'
#' @usage
#' translate_list_terminologies(NextToken, MaxResults)
#'
#' @param NextToken If the result of the request to ListTerminologies was truncated, include
#' the NextToken to fetch the next group of custom terminologies.
#' @param MaxResults The maximum number of custom terminologies returned per list request.
#'
#' @section Request syntax:
#' ```
#' svc$list_terminologies(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname translate_list_terminologies
translate_list_terminologies <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTerminologies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .translate$list_terminologies_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .translate$list_terminologies_output()
  svc <- .translate$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$list_terminologies <- translate_list_terminologies

#' Translates input text from the source language to the target language
#'
#' Translates input text from the source language to the target language.
#' It is not necessary to use English (en) as either the source or the
#' target language but not all language combinations are supported by
#' Amazon Translate. For more information, see [Supported Language
#' Pairs](http://docs.aws.amazon.com/translate/latest/dg/pairs.html).
#' 
#' -   Arabic (ar)
#' 
#' -   Chinese (Simplified) (zh)
#' 
#' -   Chinese (Traditional) (zh-TW)
#' 
#' -   Czech (cs)
#' 
#' -   Danish (da)
#' 
#' -   Dutch (nl)
#' 
#' -   English (en)
#' 
#' -   Finnish (fi)
#' 
#' -   French (fr)
#' 
#' -   German (de)
#' 
#' -   Hebrew (he)
#' 
#' -   Indonesian (id)
#' 
#' -   Italian (it)
#' 
#' -   Japanese (ja)
#' 
#' -   Korean (ko)
#' 
#' -   Polish (pl)
#' 
#' -   Portuguese (pt)
#' 
#' -   Russian (ru)
#' 
#' -   Spanish (es)
#' 
#' -   Swedish (sv)
#' 
#' -   Turkish (tr)
#' 
#' To have Amazon Translate determine the source language of your text, you
#' can specify `auto` in the `SourceLanguageCode` field. If you specify
#' `auto`, Amazon Translate will call Amazon Comprehend to determine the
#' source language.
#'
#' @usage
#' translate_translate_text(Text, TerminologyNames, SourceLanguageCode,
#'   TargetLanguageCode)
#'
#' @param Text &#91;required&#93; The text to translate. The text string can be a maximum of 5,000 bytes
#' long. Depending on your character set, this may be fewer than 5,000
#' characters.
#' @param TerminologyNames The TerminologyNames list that is taken as input to the TranslateText
#' request. This has a minimum length of 0 and a maximum length of 1.
#' @param SourceLanguageCode &#91;required&#93; The language code for the language of the source text. The language must
#' be a language supported by Amazon Translate.
#' 
#' To have Amazon Translate determine the source language of your text, you
#' can specify `auto` in the `SourceLanguageCode` field. If you specify
#' `auto`, Amazon Translate will call Amazon Comprehend to determine the
#' source language.
#' @param TargetLanguageCode &#91;required&#93; The language code requested for the language of the target text. The
#' language must be a language supported by Amazon Translate.
#'
#' @section Request syntax:
#' ```
#' svc$translate_text(
#'   Text = "string",
#'   TerminologyNames = list(
#'     "string"
#'   ),
#'   SourceLanguageCode = "string",
#'   TargetLanguageCode = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname translate_translate_text
translate_translate_text <- function(Text, TerminologyNames = NULL, SourceLanguageCode, TargetLanguageCode) {
  op <- new_operation(
    name = "TranslateText",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .translate$translate_text_input(Text = Text, TerminologyNames = TerminologyNames, SourceLanguageCode = SourceLanguageCode, TargetLanguageCode = TargetLanguageCode)
  output <- .translate$translate_text_output()
  svc <- .translate$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.translate$operations$translate_text <- translate_translate_text
