% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning_operations.R
\name{machinelearning_get_data_source}
\alias{machinelearning_get_data_source}
\title{Returns a DataSource that includes metadata and data file information,
as well as the current status of the DataSource}
\usage{
machinelearning_get_data_source(DataSourceId, Verbose)
}
\arguments{
\item{DataSourceId}{[required] The ID assigned to the \code{DataSource} at creation.}

\item{Verbose}{Specifies whether the \code{GetDataSource} operation should return
\code{DataSourceSchema}.

If true, \code{DataSourceSchema} is returned.

If false, \code{DataSourceSchema} is not returned.}
}
\description{
Returns a \code{DataSource} that includes metadata and data file information,
as well as the current status of the \code{DataSource}.
}
\details{
\code{GetDataSource} provides results in normal or verbose format. The
verbose format adds the schema description and the list of files pointed
to by the DataSource to the normal format.
}
\section{Request syntax}{
\preformatted{svc$get_data_source(
  DataSourceId = "string",
  Verbose = TRUE|FALSE
)
}
}

\keyword{internal}
