% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_list_collections}
\alias{rekognition_list_collections}
\title{Returns list of collection IDs in your account}
\usage{
rekognition_list_collections(NextToken, MaxResults)
}
\arguments{
\item{NextToken}{Pagination token from the previous response.}

\item{MaxResults}{Maximum number of collection IDs to return.}
}
\description{
Returns list of collection IDs in your account. If the result is
truncated, the response also provides a \code{NextToken} that you can use in
the subsequent request to fetch the next set of collection IDs.
}
\details{
For an example, see Listing Collections in the Amazon Rekognition
Developer Guide.

This operation requires permissions to perform the
\code{rekognition:ListCollections} action.
}
\section{Request syntax}{
\preformatted{svc$list_collections(
  NextToken = "string",
  MaxResults = 123
)
}
}

\examples{
# This operation returns a list of Rekognition collections.
\dontrun{svc$list_collections()}

}
\keyword{internal}
