% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_list_vocabularies}
\alias{transcribeservice_list_vocabularies}
\title{Returns a list of vocabularies that match the specified criteria}
\usage{
transcribeservice_list_vocabularies(NextToken, MaxResults, StateEquals,
  NameContains)
}
\arguments{
\item{NextToken}{If the result of the previous request to \code{ListVocabularies} was
truncated, include the \code{NextToken} to fetch the next set of jobs.}

\item{MaxResults}{The maximum number of vocabularies to return in the response. If there
are fewer results in the list, this response contains only the actual
results.}

\item{StateEquals}{When specified, only returns vocabularies with the \code{VocabularyState}
field equal to the specified state.}

\item{NameContains}{When specified, the vocabularies returned in the list are limited to
vocabularies whose name contains the specified string. The search is
case-insensitive, \code{ListVocabularies} returns both \"vocabularyname\" and
\"VocabularyName\" in the response list.}
}
\description{
Returns a list of vocabularies that match the specified criteria. If no
criteria are specified, returns the entire list of vocabularies.
}
\section{Request syntax}{
\preformatted{svc$list_vocabularies(
  NextToken = "string",
  MaxResults = 123,
  StateEquals = "PENDING"|"READY"|"FAILED",
  NameContains = "string"
)
}
}

\keyword{internal}
